#include "mbed.h"
#include "Data.h"
#define Period 1 //5000ms
#define PPR 1
#define periphery 2.233168 //periphery of the wheel, in this example a 28" wheel.



int count;
time_t StartTime;
double distance;
double lastDistance;
int lastCount;

void interval(void){
    lastDistance = count * periphery / PPR;
    distance += lastDistance;
    lastCount = count;
    count = 0;
    }
    
void pressed(void){
    count++;
}
    
Data::Data(PinName pin) : button(pin){
    StartTime = time(NULL);
    count = 0;
    distance = 0;
    tick.attach(interval,Period);
    button.fall(pressed);
    }
    
double Data::getDistance(void){
    return distance;
    }

int Data::getTime(void){
    return time(NULL) - StartTime;
    }
    
double Data::getSpeed(void){
    return lastDistance/Period * 3.6;
    }
    
double Data::getAverage(void){
    return distance/(time(NULL) - StartTime) * 3.6;
    }
    
int Data::getLastCount(void){
    return lastCount;
   } 