/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
#include "mbed.h"
#include "Data.h"
#include "ble/BLE.h"
//#include "ble/services/ButtonService.h"
#include "ble/services/BikeService.h"
#include "ble/services/HealthThermometerService.h"
//#include "ble/services/BatteryService.h"
 
//DigitalOut  led1(LED1);
//InterruptIn button(PC_13);
 
const static char     DEVICE_NAME[] = "Veloke";
static const uint16_t uuid16_list[] = {BikeService::BIKE_SERVICE_UUID, /*GattService::UUID_BATTERY_SERVICE*/ /*ButtonService::BUTTON_SERVICE_UUID*/};
Data d(PC_13);
 
/*enum {
    RELEASED = 0,
    PRESSED,
    IDLE
};
static uint8_t buttonState = IDLE;*/
 
//static ButtonService *buttonServicePtr;
 static BikeService *bikeServicePtr;
 //static BatteryService *bsp;
 static bool update = false;
 //static uint8_t afstand = 0;
 //static uint8_t gemiddelde = 0;
 
/*void buttonPressedCallback(void)
{*/
    /* Note that the buttonPressedCallback() executes in interrupt context, so it is safer to access
     * BLE device API from the main thread. */
 /*    printf("pushed\n");
     counter++;
    buttonState = PRESSED;
}*/
 
/*void buttonReleasedCallback(void)
{*/
    /* Note that the buttonReleasedCallback() executes in interrupt context, so it is safer to access
     * BLE device API from the main thread. */
  /*   printf("released\n");
    buttonState = RELEASED;
}*/

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    BLE::Instance().gap().startAdvertising();
}
 
void periodicCallback(void)
{
    //led1 = !led1;  Do blinky on LED1 to indicate system aliveness.
    //afstand = (uint8_t)d.getDistance();
    //gemiddelde = (uint8_t)d.getAverage();
    printf("distance: %f \r\nTime Passed: %i:%i\nAverage: %f\nSpeed: %f\n\n",d.getDistance(), d.getTime()/60, d.getTime()%60, d.getAverage(), d.getSpeed());
    update = true;
}
 
/**
 * This function is called when the ble initialization process has failled
 */
void onBleInitError(BLE &ble, ble_error_t error)
{
    /* Initialization error handling should go here */
}
 
/**
 * Callback triggered when the ble initialization process has finished
 */
void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    BLE&        ble   = params->ble;
    ble_error_t error = params->error;
 
    if (error != BLE_ERROR_NONE) {
        /* In case of error, forward the error handling to onBleInitError */
        onBleInitError(ble, error);
        return;
    }
 
    /* Ensure that it is the default instance of BLE */
    if(ble.getInstanceID() != BLE::DEFAULT_INSTANCE) {
        return;
    }
 
    ble.gap().onDisconnection(disconnectionCallback);
 
    /* Setup primary service */
    bikeServicePtr = new BikeService(ble,d.getDistance(),d.getAverage()/*, false*/ /* initial value for button pressed */);
    //bsp = new BatteryService(ble,counter);
    //buttonServicePtr = new ButtonService(ble,false);
 
    /* setup advertising */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.gap().setAdvertisingInterval(1000); /* 1000ms. */
    ble.gap().startAdvertising();
 
}
 
int main(void)
{
    
    
    //led1 = 1;
    Ticker ticker;
    ticker.attach(periodicCallback, 1);
    //button.fall(buttonPressedCallback);
    //button.rise(buttonReleasedCallback);
 
    BLE &ble = BLE::Instance();
    BLE::Instance().init(bleInitComplete);
    
    /* SpinWait for initialization to complete. This is necessary because the
     * BLE object is used in the main loop below. */
    while (ble.hasInitialized()  == false);  /* spin loop */ 
    
    /*while (true) {
        if (buttonState != IDLE) {
            bikeServicePtr->updateBikeDistance(counter);
            buttonState = IDLE;
        }
 
        ble.waitForEvent();
    }*/
    while(true){
        if (update == true){
            bikeServicePtr->updateBikeDistance(d.getDistance());
            bikeServicePtr->updateBikeAverage(d.getAverage());
            bikeServicePtr->updateBikePulse(d.getLastCount());
            //test = (int)d.getDistance();
            //bsp->updateBatteryLevel(test);
            update = false;
            }
        ble.waitForEvent();
        }
}