
/** @file
 *  @brief main program entry
 */

#include "mbed.h"
#include "CAN.h"

#include "ppCANOpen.h"
#include "Node_pin0808.h"

DigitalOut boardLed (LED1);

void InputScan ()
{
    boardLed = !boardLed;
}


int main()
{

    printf ("\r\n----- MAIN -----\r\n");

    /* blinker task*/
    boardLed = 0;

//#define MASTER
#ifdef MASTER

    /* CanOpen start */
    ServiceProvider service;
    printf ("----- READY -----\r\n");

    Node_pin0808 node1(2, &service);
    //Node_pin0808 node2(&service);

    service.PostNmtControl(1, NMT_CS_RESET_NODE);
    service.Run();
    service.PostNmtControl(2, NMT_CS_START);
    service.Run();
    service.PostNmtControl(3, NMT_CS_START);
    service.Run();
    service.PostNmtControl(4, NMT_CS_START);
    service.Run();
    service.PostNmtControl(5, NMT_CS_START);
    service.Run();
    service.PostNmtControl(6, NMT_CS_START);
    service.Run();

    while (1) {
        service.Run();
    }

#else

    /* CanOpen start */
    ServiceProvider service;
    printf ("----- READY -----\r\n");

    Node_pin0808 node1(3, &service);

    while (1) {
        service.Run();
    }

#endif

    printf ("----- END -------\r\n\n");

}
