/**
 ******************************************************************************
 * @file
 * @author  Paul Paterson
 * @version
 * @date    2015-12-14
 * @brief   CANOpen implementation library
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2015 Paul Paterson
 *
 * All rights reserved.

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PPCAN_CANOPEN_API_H
#define PPCAN_CANOPEN_API_H

#include "stdint.h"

#ifdef __cplusplus
extern "C" {
#endif

    /*=========================================================================
     * Forward declarations
     *=========================================================================
     */
    struct CanOpenMessage;

    /*=========================================================================
     * API functions
     *=========================================================================
     */    
    
    typedef void (* ServiceProviderRxInterruptCallback)(void *pServiceObject);
    typedef void (* ServiceProviderTickCallback)       (void *pServiceObject);
    
    int CanOpenApiInit  (void *object, ServiceProviderRxInterruptCallback rxCallback, ServiceProviderTickCallback tickCallback);
    
    int CanOpenApiRead  (CanOpenMessage * canOpenMsg);
    int CanOpenApiWrite (CanOpenMessage * canOpenMsg);
    
    uint32_t CanOpenApiGetHardwareTime  (void);

#ifdef __cplusplus
};
#endif

#endif /* PPCAN_CANOPEN_API_H */