#ifndef EXAMPLE_CAN_PROTOCOL_H
#define EXAMPLE_CAN_PROTOCOL_H

#include "CanPipe.h"

/** example protocol class */
class ExampleCanProtocol {
    int adder_;
    CanPipe* p_can_pipe_;
public:
    ExampleCanProtocol(): adder_(0)
    {}

    int adder_cb(CANMessage &msg) { 
        adder_ += msg.data[0];
        printf("   ExampleCanProtocol::adder_cb - %d\r\n", adder_);
        return CanPipe::kOkay; 
    }
    
    int echo_cb(CANMessage &msg) {        
        CANMessage response(msg.id + 0x100);
        response.len = msg.len;
        response.format = CANStandard;
        response.type = CANData;
        memcpy(response.data, msg.data, msg.len);
        p_can_pipe_->PostMessage(response);
        
        printf("   ExampleCanProtocol::echo_cb \r\n");
        for (int i = 0; i < msg.len; ++i) {
            printf("      %d - 0x%02X\r\n", i, msg.data[i]);
        }
        return CanPipe::kOkay; 
    }
    
    void RegisterProtocols(CanPipe &can_pipe) {
        p_can_pipe_ = &can_pipe;
        
        int handle;
        
        handle = p_can_pipe_->RegisterFilter(0x400, 0x7ff, CANAny, 3);
        p_can_pipe_->RegisterCallback<ExampleCanProtocol>(this, &ExampleCanProtocol::adder_cb, handle);
        
        handle = p_can_pipe_->RegisterFilter(0x500, 0x700, CANAny, 2);
        p_can_pipe_->RegisterCallback<ExampleCanProtocol>(this, &ExampleCanProtocol::echo_cb, handle);
    }
};

#endif /* EXAMPLE_CAN_PROTOCOL_H */
