#include "mbed.h"
#include "CanPipe.h"
#include "ExampleCanProtocol.h"

Ticker ticker;
DigitalOut led1(LED1);

CAN m_can(P0_11, P0_31);
CanPipe m_can_pipe(&m_can);

char counter = 0;
void send() {
    led1 = !led1;
    m_can_pipe.PostMessage(CANMessage(1337, &counter, 1));
    //m_can.write(CANMessage(1337, &counter, 1));
    ++counter;
}

/* Define user static callbacks */
int user_cb1(CANMessage &msg) { printf("user_cb1\r\n"); return CanPipe::kOkay; }
int user_cb2(CANMessage &msg) { printf("user_cb2\r\n"); return CanPipe::kOkay; }
int user_cb3(CANMessage &msg) { printf("user_cb3\r\n"); return CanPipe::kOkay; }

/* main program */
int main() {
    m_can.frequency(500000);
    
    int handle;
    
    /* 1 is default hardware filter handle for ALL messages.  override it.  
     * Otherwise, other filters will be skipped 
     */
    handle = m_can.filter(0x000, 0x7ff, CANAny, 1);
    
    /* react to message 0x400 */
    handle = m_can_pipe.RegisterFilter(0x400, 0x7ff, CANAny, 3);
    m_can_pipe.RegisterCallback(CanMessageCallback(user_cb1), handle);
    
    /* react to messages 0x500 to 0x5FF */
    handle = m_can_pipe.RegisterFilter(0x500, 0x700, CANAny, 2);
    m_can_pipe.RegisterCallback(CanMessageCallback(user_cb2), handle);
    m_can_pipe.RegisterCallback(CanMessageCallback(user_cb3), handle);
    
    /* CanProtocol callbacks will be called after the user callbacks */
    ExampleCanProtocol protocol;
    protocol.RegisterProtocols(m_can_pipe);
    
    /* Schedule a message to be sent once a second */
    ticker.attach(send, 1);
    
    while (1) {
        /* We know there will be nothing to handle until there is an interrupt */
        __WFI(); //sleep();
        /* Handle the messages as soon as we can */
        m_can_pipe.HandleMessages();
    }
}