
/** @file
 *  @brief main program entry
 */
 
#include "mbed.h"

DigitalOut boardLed (LED1);
Ticker inputScanner;
int volatile input;

void InputScan ()
{
    boardLed = !boardLed;
}

int main()
{
    printf ("\r\n----- MAIN -----\r\n");
    
    /* blinker task*/
    boardLed = 0;
    input = 0;
    inputScanner.attach_us (&InputScan, 50000);

    /*=========================================================================
     * test echo
     *=========================================================================
     */
    CAN can (PA_11, PA_12);
    
    char counter = 255;
    if (! (can.write (CANMessage (1337, &counter, 1)))) {
        printf ("can.write FAILURE!\r\n");
    }
    counter = 0;
    
    CANMessage msgRx;
    
    printf ("----- READY -----\r\n");
    while (1) {
        if (can.read (msgRx)) {
            
            printf("Message received: %d ", msgRx.data[0]);
            wait (0.4); printf(".");
            wait (0.4); printf(".");
            wait (0.4); printf(". \r\n");
            
            counter++;            
            if (! (can.write (CANMessage (1337, &counter, 1)))) {
                printf ("can.write FAILURE!\r\n");
            }
        }
        
        wait (0.05);
    }
}
