// MBED driver for AD9851 digital synthesizer using hacked SPI interface
// Original code for AD9850 by Liam Goudge Sept 2013
// Modified for AD9851 and KL25Z by Mike Richards Oct 2013

#include "mbed.h"


SPI device (PTD2, PTD3, PTD1); // Set the KL25Z SPI pins
DigitalOut CS(PTD0); // Use pin PTD0 as a fake Chip select (AD9851's FQ_UD line)
DigitalOut ADReset(PTA13); // Use Pin PTA13 as the reset line for AD9851
int targetFrq; // 32-bit frequency word for the AD9851
int phase; // Phase and multiplier word for AD9851

Serial pc(USBTX, USBRX); // tx, rx for debug terminal

int reverseBits (int source)
{
// Unfortunately need to invert bit order of the desired frequency setting since MBED only allows for MSB first from SPI. We need LSB first for AD9851
    int mask=0;;
    int i=0;
    int target=0;
    int bitTarget=0x80000000; // Hard-wired for 32-bit inversion

    for (i=0;i<32;i++) { // ditto
        mask=1<<i;   
        bitTarget=1<<(31-i); // ditto

        if (source & mask)
            target=target | bitTarget;
    } 
    return target;
}    
     
void writeSPI(int frq, int phase)
{           
// Send the 40-bit packet. NB: KL25Z only supports 8-bit SPI so send five 8-bit packets
    
    device.format(8,0); // 8-bits per packet, mode 0 (CPOL=0 CPHA=0)
    device.frequency(1000000); //SPI clock set to 1MHz

    wait_ms(1);

    // First do chip select. Need to use a GPIO to fake the chip select since MBED doesn't allow to set positive logic CS signal
    CS=1; // assert chip select (a.k.a FQ_UD frequency update input to AD9851)
    wait_ms(1);
    CS=0;
    
    // Write 5 x 8-bit packets for the frequency word  
    device.write(frq>>24); // Packet 1
    device.write(frq>>16); // Packet 2
    device.write(frq>>8);  // Packet 3
    device.write(frq);     // Packet 4
    device.write(phase);   // Packet 5 - Finish with the phase, multiplier and factory settings byte

    // Now pulse FQ_UD again to load the word into the DDS
    CS=0;
    wait_ms(1);
    CS=1;
    wait_ms(1);
    CS=0;
}
    

int main()
{
    
    
    int DesFrq = 5000000; // Set the desired output frequency in Hz
    float Mult = 23.86093; // Multiplier for boards using a 30MHz clock oscillator and 6x multiplier
    targetFrq= DesFrq * Mult ; // targetFrq is the 32-bit frequency word for the AD9851
    phase = 0x80; // Set the 6x clock multiplier for systems with 30MHz reference oscillator.
    
    // Reset the AD9851. Active high logic. Minimum reset period 5 clock cycles
    ADReset=0;
    wait_ms(5);
    ADReset=1;
    wait_ms(5);
    ADReset=0;
        
    
    while(1)
    {
    
    writeSPI(reverseBits(targetFrq),phase); // Transfer the frequency settings to the AD9851
   
   
    
    }      
        
        
}