/* Program 7.4: Read ADXL345 accelerometer through SPI.
Outputs continuously to terminal
*/

#include "mbed.h"

SPI acc(p11,p12,p13);           //Set up SPI MOSI, MISO, SCL
DigitalOut cs(p10);             //set up chip select
Serial pc(USBTX, USBRX);
char buffer[6];                 //raw filler data
int16_t data[3];                //16bit twos-compliment integer data
                 
void acc_init(void){
    cs=1;                       //initially off
    acc.format(8,3);            //8bit, mode 3
    acc.frequency(2000000);     //2MHz
    cs=0;                       //select
    acc.write(0x31);            //data format register
    acc.write(0x0B);            //+/-16g, 0.004g sensitivity
    cs=1;                       //end transmission
    cs=0;                       //start new transmission
    acc.write(0x2D);            //power mode = measure
    acc.write(0x08);
    cs=1;
}
 
float acc_sense(char axis){
    float x,y;  
    cs=0;
    acc.write(0x80|0x40|0x32);      //RW bit high, MB bit high, address to ask for a reading
    for (int i=0;i<=5;i++){buffer[i]=acc.write(0x00);}           //read 6bytes
    cs=1;
    data[0]=buffer[1]<<8|buffer[0];         //x    
    data[1]=buffer[3]<<8|buffer[2];         //y         combine MSB and LSB
    data[2]=buffer[5]<<8|buffer[4];         //z
    
    x=(atan2((double)data[0],(double)data[2])*180/3.1416);      //convert the signal into an angle, to be passed out as x,y
    y=(atan2((double)data[1],(double)data[2])*180/3.1416);
    
//    pc.printf("Angle x = %1.2f \t Angle y = %1.2f \n\r", x,y);
    
    if(axis==1) return x;       //if asked for x, give x
    if(axis==2) return y;       //if asked for y, give y
}
