#include "Tap.h"
I2C acc(p9,p10);
DigitalIn int2(p20);
InterruptIn check(p12);
BusOut led(LED1,LED2,LED3,LED4);
char acc_config[2];
const int addr=(0x53<<1);
char data1[1];
char ack;

void Tap_init() 
    {
    acc.frequency(100000);   
    acc_config[0]=0x31; acc_config[1]=0x0B;         //data format
    ack = acc.write(addr,acc_config, 2);
    wait(0.1);
      
    acc_config[0]=0x2D; acc_config[1]=0x08;         //power control->measure mode
    acc.write(addr,acc_config, 2);   
    wait(0.1);
    
    acc_config[0]=0x1D; acc_config[1]=0x50;         //Tap Threshold ->5g 
    acc.write(addr,acc_config, 2); 
    wait(0.1);
    
    acc_config[0]=0x21; acc_config[1]=0x10;         //Tap duration -> 0.01
    acc.write(addr,acc_config, 2);    
    wait(0.1);
    
    acc_config[0]=0x22; acc_config[1]=0x05;         //Tap Gap ~0.006
    acc.write(addr,acc_config, 2); 
    wait(0.1);
    
    acc_config[0]=0x23; acc_config[1]=0xFF;         //Tap window ->~0.38175
    acc.write(addr,acc_config, 2);
    wait(0.1);
    
    acc_config[0]=0x2A; acc_config[1]=0x07;         //Axis -> x&y&z
    acc.write(addr,acc_config, 2);
    wait(0.1);
    
    acc_config[0]=0x2E; acc_config[1]=0x60;         //enable interupt -> single and double tap
    acc.write(addr,acc_config, 2);
    wait(0.1);
    
    acc_config[0]=0x2F; acc_config[1]=0x60;         //map interupt ->int2
    acc.write(addr,acc_config, 2);
    wait(0.1);
    }
    float Tap()
    {    
        int2.rise(&Tap_return)
        while(1)
            {
            wait(0.01);
            
            if(int2.read()==1)  // Check for interupt signal
            {
               
                acc_config[0]=0x30;
                acc.write(addr,acc_config,1);             
                acc.read(addr,data1,1);  // Get interupt information
                
                if(data1[0] & 0x40)  // Turn on one LED for one tap
                {
                    led =1; 
                }
                if(data1[0] & 0x20)  // Turn on two LEDs for two taps
                {
                    led =2;
                }
                wait(1);
                 // Turn off LED
                 if(led==1){return 1;}
                 if(led ==2){return 2;}
                
            }     
        }   
    }
    
    void Tap_return()
    {
            
    }