/*
This is free and unencumbered software released into the public domain.

Anyone is free to copy, modify, publish, use, compile, sell, or
distribute this software, either in source code form or as a compiled
binary, for any purpose, commercial or non-commercial, and by any
means.

In jurisdictions that recognize copyright laws, the author or authors
of this software dedicate any and all copyright interest in the
software to the public domain. We make this dedication for the benefit
of the public at large and to the detriment of our heirs and
successors. We intend this dedication to be an overt act of
relinquishment in perpetuity of all present and future rights to this
software under copyright law.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

For more information, please refer to <http://unlicense.org/>

Notes
2019-04-30
- no response from maxim requesting them to update their USB targets to 
  mbed 5.12
- making this example for 5.11.5


Ever wonder how to redirect standard in/out/error to a USBSerial interface ?
Using a *MAX32630FTHR board, here you go :)

Connect your favorite terminal, eg., CoolTerm, run the program, scan for any
new usb serial ports, connect. A USB serial port is not quite a UART so baud
doesn' matter much.


* After many many combinations of IDE's/boards, I picked the Max because I can 
easily connect my Segger J-Link for much faster traditional debugging than 
DAPLink working with VisualGDB extension to M$ Visual Studio 2017 Community 
Edition.

*/

#include "mbed.h"
#include "max32630fthr.h"
#include "USBSerial.h"

#include <stdio.h>
#include <errno.h>

// mbed-os USB virtual serial port globals
// The "usb" names a stream. I will make a pull request adding a single line 
// change to USBSerial.h to allow for this.
USBSerial usbSerial("usb");

// platform globals
MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);
DigitalOut rLED(LED1);
DigitalOut gLED(LED2);
DigitalOut bLED(LED3);


int main() {
    // redirect stdin, stdout, stderr to USBSerial object
    freopen("/usb", "r", stdin);
    freopen("/usb", "w", stdout);
    freopen("/usb", "w", stderr);
        
    rLED = LED_OFF;
    gLED = LED_OFF;
    bLED = LED_OFF;

    // wait until user ready
    while(!usbSerial.terminal_connected) {
        ThisThread::yield();
    }

    printf("--- Maxim MAC32630FTHR mbed-os 5.11.5 stdout redirect ---\n");

    // blink led indicating finished    
    while (true) {
        bLED = LED_ON;
        wait_ms(25);
        bLED = LED_OFF;
        wait_ms(2975);
    }
}

