#include "mbed.h"
// naked LPC1114 on breadboard, install LED pin28, pasive piezo-buzzer pin1
DigitalOut myled(dp28);  // LED ... P0_7 (pin 28)
Serial uart(dp16, dp15); // UART .. P1_7: TX (pin 16), P1_6: RX (pin 15)
PwmOut pwm(dp1);         // PWM ... P0_8: CT16B0_MAT0 (pin1); sorry, blocking SPI!  

int main() {
char c = '0';
  pwm.period(0.001);  // PWM period 1ms (1kHz)   
  uart.baud(115200);  // Baud rate
  uart.puts("Start.\n\r");
  while(1) {    // repeat (period 1sec)
    myled = 0;  // LED on
    pwm = 0.5;  // PWM duty cycle 50%, tone 1kHz
    wait(0.5);
    uart.putc(c++); if (c > '9') c = '0';  // Put Character & rotate 0,1,2,... 9
    myled = 1;  // LED off
    pwm = 0;    // PWM stop, silent
    wait(0.5);
    uart.puts(" Hello world.\n\r");  // Put String "Hello..."
    }
}
