#include "wifi.h"


Serial esp(p13, p14); // tx, rx

extern Serial pc;

Timer t;
int count,ended,timeout;

char ssid[32] = "fishes";     // enter WiFi router ssid inside the quotes
char pwd [32] = "1Fishesonfire23"; // enter WiFi router password inside the quotes
char buf[2024];
char snd[1024];

// Private Functions
void SendCMD()
{
    //pc.printf("%s", snd);
    esp.printf("%s", snd);
}

void flush(){
 while(esp.readable()) {
        char tmp = esp.getc();
        //data += tmp;
        //pc.putc(tmp);
 }
}

void getreply()
{
    memset(buf, '\0', sizeof(buf));
    t.start();
    ended=0;
    count=0;
    while(!ended) {
        if(esp.readable()) {
            buf[count] = esp.getc();
            count++;
        }
        if(t.read() > timeout) {
            ended = 1;
            t.stop();
            t.reset();
        }
    }
}

void ESPsetbaudrate()
{
    strcpy(snd, "uart.setup(0, 9600, 8, 0, 1, 0)\r\n");   // change the numeric value to the required baudrate
    SendCMD();
    timeout=2;
    getreply();
    //pc.printf(buf);
}


// Public Functions


void setup_wifi()
{
    //pc.printf("---------- Reset & get Firmware ----------\r\n");
    strcpy(snd,"node.restart()\r\n");
    SendCMD();
    timeout=2;
    getreply();
    //pc.printf(buf);
    
    ESPsetbaudrate();
    
    
    pc.printf("\n---------- Connecting to AP ----------\r\n");
    pc.printf("ssid = %s   pwd = %s\r\n",ssid,pwd);
    strcpy(snd, "wifi.sta.config(\"");
    strcat(snd, ssid);
    strcat(snd, "\",\"");
    strcat(snd, pwd);
    strcat(snd, "\")\r\n");
    SendCMD();
    timeout=3;
    getreply();
    //pc.printf(buf);
 
    wait(1);
 
    pc.printf("\n---------- Get IP's ----------\r\n");
    strcpy(snd, "print(wifi.sta.getip())\r\n");
    SendCMD();
    timeout=2;
    getreply();
    pc.printf(buf);
 
    wait(1);
 
    pc.printf("\n---------- Get Connection Status ----------\r\n");
    strcpy(snd, "print(wifi.sta.status())\r\n");
    pc.printf("%s", snd);
    SendCMD();
    timeout=2;
    getreply();
    pc.printf(buf);
  
    
}

void setup_ntp(){
    strcpy(snd, "timezone = -4\r\n");
        SendCMD();
        wait(2);
    strcpy(snd, "request=string.char(227,0,6,236,0,0,0,0,0,0,0,0,49,78,49,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)\r\n");
        SendCMD();
        wait(4);
    
    strcpy(snd, "time = 0\r\n");
        SendCMD();
        wait(1);
    strcpy(snd, "sk=net.createConnection(net.UDP, 0)\r\n");
        SendCMD();
        wait(1);
  
    strcpy(snd, "sk:on(\"receive\", function(sck, payload)\r\n");
        SendCMD();
        wait(1);
    strcpy(snd, "local highw,loww,ntpstamp\r\n");
        SendCMD();
        wait(1);
    strcpy(snd, "highw = payload:byte(41) * 256 + payload:byte(42)\r\n");
        SendCMD();
        wait(1);
    strcpy(snd, "loww = payload:byte(43) * 256 + payload:byte(44)\r\n");
        SendCMD();
        wait(1);
    strcpy(snd, "ntpstamp=( highw * 65536 + loww ) + ( timezone* 3600)\r\n");
        SendCMD();
        wait(1);
    strcpy(snd, "time = ntpstamp - 1104494400 - 1104494400\r\n");
        SendCMD();
        wait(1);
    strcpy(snd, "print(time)\r\n");
        SendCMD();
        wait(1);
 
    strcpy(snd, "sck:close()\r\n");
        SendCMD();
        wait(1);
 
    strcpy(snd, "end )\r\n");
        SendCMD();
        wait(1);
 
    flush();       
    wait(5);
}

void update_ntp(){
    flush();
    strcpy(snd, "sk:connect(123,\"104.232.3.3\")\r\n");
        SendCMD();
        wait(3);
    strcpy(snd, "sk:send(request)\r\n");
        SendCMD();
        wait(4);
    
    flush();
    
    strcpy(snd, "print(time)\r\n");
        SendCMD();
        wait(1);
    timeout=5;
    getreply();
    //pc.printf(buf);
    int utime = atoi(buf);
    if(utime != NULL)
        set_time(utime);
    time_t seconds = time(NULL);
    //pc.printf("Time as a basic string = %s", ctime(&seconds));
}

void setup_http()
{
     
          pc.printf("\n---------- Setting up http server ----------\r\n");

        strcpy(snd, "log={'test','hey Edison'}\r\n");
        SendCMD();
        wait(1);
          
        strcpy(snd, "srv=net.createServer(net.TCP)\r\n");
        SendCMD();
        wait(1);
        strcpy(snd, "srv:listen(80,function(conn)\r\n");
        SendCMD();
        wait(1);
        strcpy(snd, "conn:on(\"receive\",function(conn,payload)\r\n");
        SendCMD();
        wait(1);
 
        strcpy(snd, "conn:send(\"<!DOCTYPE html>\")\r\n");
        SendCMD();
      wait(1);
        
        strcpy(snd, "conn:send(\"<html>\")\r\n");
        SendCMD();
      wait(1);
        
        strcpy(snd, "for key,value in pairs(log) do conn:send(\"<p>\" .. value .. \"<p>\") end\r\n");
        SendCMD();
        wait(1);
       
        strcpy(snd, "conn:send(\"</html>\")\r\n");
    SendCMD();
    wait(1);
        
        strcpy(snd, "end)\r\n");
    SendCMD();
    wait(1);
        
        strcpy(snd, "conn:on(\"sent\",function(conn) conn:close() end)\r\n");
    SendCMD();
    wait(1);
        strcpy(snd, "end)\r\n");
    SendCMD();
    
    flush();

}

void update_log(vector<string>& log)
{
    strcpy(snd, "log={");
        //SendCMD();
        //wait(1);
        
    for(unsigned i=0; i<log.size(); i++){
        strcat(snd, "\"");
        strcat(snd, log[i].c_str());
        strcat(snd, "\"");
        if(i<log.size()-1)
            strcat(snd, ",");
        //SendCMD();
        //wait(1);

    }
    strcat(snd, "}\r\n");
    pc.printf("%s\n\r",snd);
        SendCMD();
        wait(2);   
    flush();
} 
    