#include "mbed.h"
#include "DebounceIn.h"
#include "USBKeyboard.h"
#include "MMA8451Q.h"

PinName const SDA = PTE25;
PinName const SCL = PTE24;
#define MMA8451_I2C_ADDRESS (0X1d<<1)
Serial pc(USBTX, USBRX);

USBKeyboard keyboard;

DigitalOut ledr(LED_RED);
DigitalOut ledg(LED_GREEN);
DigitalOut ledb(LED_BLUE);

DebounceIn pb1(D2);
DebounceIn pb2(D3);
DebounceIn pb3(D4);
DebounceIn pb4(D5);
DebounceIn pb5(D6);
DebounceIn pb6(D7);
DebounceIn pb7(D8);
DebounceIn pbs(D9);
DebounceIn pbm(D10);

int main()
{ 
int m = 1;
ledr = 1;
ledg = 1;
ledb = 1;
    // Use internal pullup for pushbutton
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    pb3.mode(PullUp);
    pb4.mode(PullUp);
    pb5.mode(PullUp);
    pb6.mode(PullUp);
    pb7.mode(PullUp);
    pbs.mode(PullUp);
    pbm.mode(PullUp);
    
    // Delay for initial pullup to take effect
    wait(.001);
    
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    
    float x;
    float y;
    float z;
    
    while(true) 
        {
        x = acc.getAccX();
        y = acc.getAccY();
        z = acc.getAccZ();
        keyboard.printf("X = %1.2f   ", x);
        keyboard.printf("Y = %1.2f   ", y);
        keyboard.printf("Z = %1.2f\n", z);
        wait(0.05f);
        }
    
}