#include "mbed.h"
#include "VS1002.h"
#include "TextLCD.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "DebounceIn.h"
#include "Motor.h"
#include <string>
#include<stdlib.h>
#define PI 3.14
#define DIAMETER 0.076                                    
#define MINIMUM_FARE 11
#define FARE_PER_KM 10

TextLCD fareDisplay(p10, p18, p24, p23, p22, p21 );
VS1002 audioDriver(p11, p12, p13, p8, "sd",
           p5, p6, p7, p14, p15,
           p16, p17, p20);
EthernetNetIf ethernet;                 
HTTPClient http;                   
AnalogIn sensorReading(p19);
DebounceIn setup(p9);
DebounceIn startMeter(p20);
DebounceIn stopMeter(p30);
DebounceIn playFare(p29);
Motor m(p25, p26, p27); 

void initializeAudioDriver()
{
#ifndef FS_ONLY
    audioDriver._RST = 1;
    audioDriver.cs_high();                                   
    audioDriver.sci_initialise();                            
    audioDriver.sci_write(0x00,(SM_SDINEW+SM_STREAM+SM_DIFF));
    audioDriver.sci_write(0x03, 0x9800);
    audioDriver.sdi_initialise();
#endif
}

float calculateFare(int noOfRevolutions)
{
    float distanceinKM;    
    distanceinKM = noOfRevolutions*PI*DIAMETER;//For Demo purposes we do not divide by 1000 as would be in real scenario.
    float fare;
    if(distanceinKM>1)
    fare = MINIMUM_FARE + FARE_PER_KM*(distanceinKM - 1); // Formula can be changed as per required or can be taken dynamically from a web server
    else
    fare = MINIMUM_FARE;
    return fare;
}


void convertFareToSpeech(float fare)
{
    string ttsURL=" http://translate.google.com/translate_tts?tl=en&q=Your+Fare+is+;+";
    char strFare[100];
    sprintf(strFare,"%d",(int)fare);
    ttsURL+=strFare; 
    ttsURL+="+Rupees+.+Thank+you+for+the+ride+.+Have+a+Nice+Day+.";
    //printf("%s\n",ttsURL);
    HTTPFile audioOutput("/sd/Fare.mp3");
    HTTPResult result = http.get(ttsURL.c_str(),&audioOutput);
    if(result!=HTTP_OK)
    {
          printf("Error during speech convrsion!! Error Number : %d\n", result);
    }
    else
    printf("Done\n");
    audioDriver.play_song("/sd/Fare.mp3");
    
}

void initialize_system()
{    
    setup.mode(PullUp);
    wait(0.001);
    startMeter.mode(PullUp);
    wait(0.001);
    stopMeter.mode(PullUp);
    wait(0.001);
    playFare.mode(PullUp);
    wait(0.001);
    wait(2);
    fareDisplay.printf("PRESS SETUP");
    printf("Press setup to continue.....\n");
}

int main()
{ 
    bool flag = false;
    int noOfRevolutions =0;
    float fare;
    bool isMeterStopped=false;
    
    initialize_system();
    
    while(setup==1){wait(0.1);}
    while(setup == 0){wait(0.1);}
    fareDisplay.cls();
    fareDisplay.printf("INITIALIZING...");

    initializeAudioDriver();        
    EthernetErr error = ethernet.setup();
    if(error)
    {
        printf("Error in correction. Error number: %d.\n", error);
        return -1;
    }
    printf(" Connection established\n");
    
    while(1)
    {
        fareDisplay.cls();
        fareDisplay.printf("START METER");
        printf("Press start to continue.....\n");
        while(startMeter==1){wait(0.1);}
        while(startMeter==0){wait(0.1);}
        int new_val = 0;
        int old_val =0;
        fareDisplay.cls();
        fareDisplay.printf("METER STARTED");
        {        
            m.speed(0.15); 
        }
        while(!isMeterStopped)
        {
            if(sensorReading>0.5)
            {
                flag=true;
                wait(0.1);
            }
            if(flag)
            {
                if(sensorReading<0.4)
                {
                    flag=false;
                    noOfRevolutions++;                     
                }
            }
            new_val = stopMeter;
            if ((new_val==0) && (old_val==1))
            {        
               isMeterStopped = true;
               fareDisplay.cls();
               fareDisplay.printf("METER STOPPED !!");           
               m.speed(0);
            }   
             old_val=new_val; 
             wait(0.1);
        }
        
         if(isMeterStopped)
         {
            isMeterStopped = false;
            fare = calculateFare(noOfRevolutions);
            fareDisplay.cls();
            fareDisplay.printf("The Fare is: %d",(int)fare);
            printf("The no of revolutions is: %d\n; The Fare is: %d\n",(int)noOfRevolutions,(int)fare);
            convertFareToSpeech(fare);
         }   
         bool isExit =false;
         while(1)
         {         
            while(playFare==1)
            {
                new_val = stopMeter;    
                if ((new_val==0) && (old_val==1))
                {  
                  isExit = true;      
                  break;
                }   
                 old_val=new_val; 
                 wait(0.2);
             }
            while(playFare==0){wait(0.1);}
            if(isExit)
            break;
            audioDriver.play_song("/sd/Fare.mp3");
            
         }
     }  
}
