//Simple testing of buttons and inputs
// "//a" = Alternate Good Test Code

#define ENABLE_uSerial 1 //PR: Enable Debug on mbed's USB Serial

#include "mbed.h"

//==========Debug Console==========
#if ENABLE_uSerial
    //Restart TeraTerm just before Pressing Reset on mbed, Default Serual=9600-8N1(No Flow Control)
    //Using default baud rate to avoid issues with DEBUG in a constructor being at default baud rate before main()
    //TeraTerm: http://en.sourceforge.jp/projects/ttssh2/releases/
    Serial  debug_userial(USBTX, USBRX); //PR: DebugSerialOverMbedUSB
    #define DEBUG(...) { debug_userial.printf(__VA_ARGS__); }
#else
    #define DEBUG(...) //Do Nothing, DEBUG() lines are ignored
#endif 

//========== IO Hardware: Buttons, LEDs, PWM ==========
// Inputs:
DigitalIn       bB1in(BUTTON1); //if(bB1in){}
DigitalIn       bB2in(BUTTON2); //if(bB2in){}
InterruptIn     B1int(BUTTON1); //B1int.rise(&onB1rise);  
InterruptIn     B2int(BUTTON2); //B1int.fall(&onB1fall);

// Outputs:
DigitalOut      bL1out(LED1);   // Direct LED1 drive
//DigitalOut    bL2out(LED2);   // Direct LED2 drive
//PwmOut fL1pwm(LED1); float fL1level = 0.1; // PWM LED1, brightness=float(0.0~1.0)
PwmOut fL2pwm(LED2); float fL2level = 0.1; // PWM LED2, brightness=float(0.0~1.0)

//==========Functions: onButton Callbacks for InterruptIn for Buttons==========
// *When direct driving hardware consider adjusting drive within the onCallback to reduce response time
//TODO: Check need of volatile for changes in interrupts affecting variables in non-interrupt code?
volatile uint8_t uB1rise; void onB1rise(void){ uB1rise++; };// Flag Event, Counter helps detect missed events since last cleared
volatile uint8_t uB1fall; void onB1fall(void){ uB1fall++; };// Flag Event, Counter helps detect missed events since last cleared
volatile uint8_t uB2rise; void onB2rise(void){ uB2rise++; };// Flag Event, Counter helps detect missed events since last cleared
volatile uint8_t uB2fall; void onB2fall(void){ uB2fall++; };// Flag Event, Counter helps detect missed events since last cleared

//==========Functions:Timer==========
static volatile uint8_t uTicker1;   //Volatile, don't optimize, changes under interrupt control
void onTicker1(void)
{
    static uint32_t u32_Counter;
    fL2level+=0.2; if (fL2level>0.5){fL2level = 0.0;}; fL2pwm=fL2level;//LED2=Ramp Blink
    ++u32_Counter;
    //DEBUG("onT(%u) ", u32_Counter); //Count of Ticker events to support long term timer evaluation
    uTicker1++;   //PR: Flag: count of Ticker1 Events since last cleared (Helps detect missed events).
}

//========== main ==========
int main() 
{  
    DEBUG("\n\nButtonsV05 - Direct and using InterruptIn, LED1=Button1, LED2 is PWM\n");
    DEBUG(" Built:[ %s %s ]  Compiler: [ %s ]  Version:[ %s ]\n", __DATE__, __TIME__, __VERSION__);
    
    Ticker ticker1;                 //PR: Timer Object(Structure)
    ticker1.attach(onTicker1, 0.5); //PR: Timer Handler, Float=PeriodSeconds
    
    // Setup InterruptIn for Buttons
    B1int.fall(&onB1fall);// Press   Button1
    B1int.rise(&onB1rise);// Release Button1
    B2int.fall(&onB2fall);// Press   Button2
    B2int.rise(&onB2rise);// Release Button2
      
    while(1) {
        sleep();        // Wait for any interrupt, allows registered onCallback() for timer/buttons/etc.
        bL1out=bB1in;   //Direct LED1=Button1
        //a if(uTicker1){DEBUG("T%d ",  uTicker1); uTicker1=0;}
        if(uB1fall){ DEBUG("B1f%d ", uB1fall); uB1fall=0; } //PressB1
        if(uB1rise){ DEBUG("B1r%d ", uB1rise); uB1rise=0; } //ReleaseB1
        if(uB2fall){ DEBUG("B2f%d ", uB2fall); uB2fall=0; } //PressB2
        //a if(uB2rise){ DEBUG("B2r%d\n",uB2rise); uB2rise=0; } //ReleaseB2 == Newline
        if(uB2rise){ DEBUG("B2r%d\nTicker%04d ",uB2rise, uTicker1); uB2rise=0; uTicker1=0;} //ReleaseB2, +Ticks
        //DEBUG(" Loop "); // This can trigger a Serial Interrupt leading to continuous waking from sleep()
    }
}
//========== end main.cpp ==========
