#ifndef DS1307_H
#define DS1307_H
#include "mbed.h"
 
#define DS1307_addr 0xD0    // this is fixed by Dallas
#define DS1307_freq 100000  // this is the Dallas spec for operating i2c for this device
#define DS1307_sec 0x00     // seconds
#define DS1307_min  0x01    // min
#define DS1307_hour 0x02    // hours
#define DS1307_day  0x03    // day
#define DS1307_date 0x04    // date
#define DS1307_month 0x05   // month
#define DS1307_year 0x06    // year
#define DS1307_sqrout 0x07  // square output register
#define DS1307_ramstart 0x08    // register address that ram starts at
#define DS1307_lastreg 0x3F // this is the last register in the device (note also this register is used to address everything so it gets clobbered)
#define DS1307_lastram 0x3E // last usable ram by this class as the lastreg is clobbered by code for normal operation
 class DS1307 {
public:
DS1307( PinName sda, PinName slc) ;                 // constructor
 
    ~DS1307();                                          // destructor
  int read( int addr, int quantity, char *data);      // to read some of the 63 bytes from DS1307
 int read(int addr, int *data);
 int write( int addr, int quantity, char *data); 
 int write( int addr, int data );                    // to write one byte only
 int start_clock(void);    
  int stop_clock(void);                               // stop clock
 int twelve_hour(void);    
 int twentyfour_hour(void);   
 int settime(int sec, int min, int hour, int day, int date, int month, int year); 
 int gettime(int *sec, int *min, int *hour, int *day, int *date, int *month, int *year);  // to get the current time information
 
 
protected:
    I2C ds1307i2c;
    int dectobcd( int );
    int bcdtodec( int );
    int hilow_check( int, int, int);
 
};
 
#endif
            