#include "mbed.h"
#include "nRF24L01P.h"
#include "MMA8451Q.h"
#include "TSISensor.h"
#define address 0x1d<<1

MMA8451Q acc(PTE25,PTE24,address);
TSISensor TSI;

Serial pc(USBTX, USBRX); // tx, rx

nRF24L01P my_nrf24l01p(PTD2, PTD3, PTD1, PTD0, PTD5, PTD4);    // mosi, miso, sck, csn, ce, irq
DigitalOut RedLED(PTA5);

int main()
{
    char count[3];
    char TxDataCnt;
    char temp;


    my_nrf24l01p.powerUp();
    my_nrf24l01p.setRfFrequency(2417);

    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    pc.printf( "Simple Transmitter (0 - 9 Counter) \r\n");

    TxDataCnt = 3;
    my_nrf24l01p.setTransferSize(TxDataCnt);

    my_nrf24l01p.enable();

   

    while (1) {
                    count[0] = (-1*10.1*acc.getAccY()+2)*60;
                    count[1] = (10.1*acc.getAccX()+2)*60;
                    count[2] = 100*TSI.readPercentage();
    
        // Send the Transmit buffer via the nRF24L01+
        temp = my_nrf24l01p.write( NRF24L01P_PIPE_P0,count, TxDataCnt );

        pc.printf( "Sending %d - %d %d %d\r\n",temp,count[0],count[1],count[2]);

        // Toggle LED1 (to help debug Host -> nRF24L01+ communication)
        RedLED = !RedLED;
    
        
  
    }
}
