/* FsHandler.cpp */
#include "mbed.h"
#include "FsHandler.h"
//#define DEBUG
#include "hl_debug.h"



TCPSocketConnection client;


static int matchstrings(const char* one, const char* two)
{
    int m = 0;

    for (m = 0; m < min(strlen(one), strlen(two)) ; m++) {
        if (one[m] != two[m])
            return m;
    }
    return m;
}

std::map<const char*, const char*> HTTPFsRequestHandler::m_fsMap;

HTTPFsRequestHandler::HTTPFsRequestHandler(const char* rootPath, const char* localPath, HTTPConnection::HTTPMessage& Msg, TCPSocketConnection& Tcp, int isMaster, int * ports, int portsCount, int * hits)
    : HTTPRequestHandler(Msg, Tcp, isMaster, ports, portsCount, hits)
{
    client = Tcp;
    m_rootPath = rootPath;
    m_localPath = localPath;

    string myPath = m_rootPath + m_localPath;

    //  Now replace the virtual root path with a mounted device path
    std::map<const char*, const char*>::iterator it;
    const char *bestMatch = NULL;
    const char *bestMatchExchange = NULL;
    int match_ind = -1;
    for (it = m_fsMap.begin() ; it != m_fsMap.end() ; it++) {
        //  find best match (if the given logical path is containted in the root
        int s = matchstrings(myPath.c_str(), it->second);
        INFO("Matching Root %s with handler %s results in %d identical characters\n", myPath.c_str(), it->second, s);
        if ((s == strlen(it->second)) && (s > match_ind)) {
            match_ind = s;
            bestMatch = it->first;
            bestMatchExchange = it->second;
        }
    }

    if (bestMatch != NULL) {
        m_rootPath = bestMatch;
        m_localPath = string(myPath).substr(strlen(bestMatchExchange));
    }

    handleRequest();
}

HTTPFsRequestHandler::~HTTPFsRequestHandler()
{
}

int HTTPFsRequestHandler::processRequest()
{

    HTTPHeaders headers;
    int retval = 0;   //success

    if (m_localPath.length() > 4)
        getStandardHeaders(headers, m_localPath.substr(m_localPath.length()-4).c_str());
    else
        getStandardHeaders(headers);

    INFO("Handling Get Request (root = %s, local = %s).", m_rootPath.c_str(), m_localPath.c_str());

    std::string reqPath;

    //  Check if we received a directory with the local bath
    if ((m_localPath.length() == 0) || (m_localPath.substr( m_localPath.length()-1, 1) == "/")) {

        if(m_isMaster == 1) {
            m_localPath += "master.html";
        } else {
            m_localPath += "index.html";
        }
    }

    reqPath = m_rootPath + m_localPath;

    printf("Mapping \"%s\" to \"%s\"", msg.uri.c_str(), reqPath.c_str());

    FILE *fp = fopen(reqPath.c_str(), "r");
    if (fp != NULL) {

        char pBuffer;

        fseek(fp, 0, SEEK_END);
        long size = ftell(fp);
        fseek(fp, 0, SEEK_SET);

        std::string line;
        
        //chunked response
        startResponse(200);
        int hitscounter = 0;

        while (!feof(fp) && !ferror(fp)
              ) {
            pBuffer = (char)fgetc(fp);
            line = line + pBuffer;

            if(pBuffer == '\n') {

                int isChange = 0;

                if(m_isMaster == 0) {
                    isChange = replaceTag(line, "$[dstip]", client.get_address());
                } else {

                    std::string port = "-";
                    std::string hit = "-";

                    if(hitscounter < m_portsCount) {
                        port = ConvertNumber(m_ports[hitscounter]);
                        hit = ConvertNumber(m_hits[hitscounter]);
                    }

                    isChange = replaceTag(line, "$[port]", port);
                    isChange = replaceTag(line, "$[hit]", hit);
                    
                    if(isChange > 0) {
                        hitscounter = hitscounter + 1;
                    }

                    port.clear();
                    hit.clear();
                }

                int length = line.length();
                processResponse(length , const_cast<char *>(line.c_str()));
                line.clear();

            }
        }

        endResponse();
        fclose(fp);
    } else {
        retval = 404;
        ERR("Requested file was not found !");
    }

    return retval;
}



int HTTPFsRequestHandler::replaceTag(std::string& subject, const std::string& search,
                                     const std::string& replace)
{
    size_t start_pos = subject.find(search);
    if(start_pos == std::string::npos)
    {
        return 0;
    }
        
    subject.replace(start_pos, search.length(), replace);
    return 1;
}

std::string HTTPFsRequestHandler::ConvertNumber(int mumber)
{
    std::string s;
    char ibuff[24]; // or what else, or use outer char array
    sprintf(ibuff,"%d",mumber); // use a proper format: "%04d"...
    s = ibuff;
    return s;
}


int HTTPFsRequestHandler::handleGetRequest()
{
    return processRequest();
}

int HTTPFsRequestHandler::handlePostRequest()
{
    return processRequest();
}

int HTTPFsRequestHandler::handlePutRequest()
{
    return processRequest();
}


