/***********************************************************/
/*Constants                                                */
/***********************************************************/

#define V_MOTOR_RATED 6 //rated motor voltage [V]. this must be set to be less than the voltage of the batteries
#define PERIOD_US 25 //define the PWM period in microseconds, currently set for 40kHz

/***********************************************************/
/*Pin setup                                                */
/***********************************************************/

//Enable PWM inout to motorcontroller
PwmOut DUT_motor(p22);
PwmOut load_motor(p21);

//Motor direction control on motor controller switch 2
DigitalOut DUT_direction(p5);
DigitalOut load_direction(p6);

/***********************************************************/
/*Subroutines                                              */
/***********************************************************/

//initialize PWM
void init_pwm () {
    //set the PWM channel periods
    DUT_motor.period_us(PERIOD_US);
    load_motor.period_us(PERIOD_US);

    //initialize duty cycle to 0 to make sure motors are off
    DUT_motor =0;
    load_motor =0;
}

/*
Set PWM duty cycle
 - Motors are connected so that they will always oppose each other.
 - Duty cycle (a float from 0-1) determines the voltage applied to the motor terminals as a percentage of the rated voltage. eg. if duty is 0.5 and rated voltage is 6V, then terminal voltage will be 3V
*/
void set_duty (float DUT_demand, float load_demand) {

//DUT batt and cap enabled
#ifdef DUT_BATT_CAP_ENABLE
    if (relay) {
        v_DUT_batt = get_voltage(v_DUT_batt_measure); //get voltage of DUT battery
        DUT_demand = DUT_demand*(V_MOTOR_RATED/v_DUT_batt); //scale the demand so that the voltage to the motor does not exceed its rated max
    } else if (relay == 0) { //if cap is currently being used
        v_cap = get_voltage(v_cap_measure); //get voltage of cap
        DUT_demand = DUT_demand*(V_MOTOR_RATED/v_cap); //scale the demand so that the voltage to the motor does not exceed its rated max
    } else {
        big_error = 1; //error flag
        big_error_led = 1; //turn on error LED
    }
    DUT_motor.write(DUT_demand); //write new DUT duty cycle
#endif

//DUT batt connected
#ifdef DUT_BATT_ENABLE
    v_DUT_batt = get_voltage(v_DUT_batt_measure); //get voltage of DUT battery
    DUT_demand = DUT_demand*(V_MOTOR_RATED/v_DUT_batt); //scale the demand so that the voltage to the motor does not exceed its rated max
    DUT_motor.write(DUT_demand); //change DUT duty cycle based on demand
#endif

//Load batt connected
#ifdef LOAD_BATT_ENABLE
    v_load_batt = get_voltage(v_load_batt_measure); //get voltage of load battery
    load_demand = load_demand*(V_MOTOR_RATED/v_load_batt); //scale the demand so that the voltage to the motor does not exceed its rated max
    load_motor.write(load_demand); //change load duty cycle based on demand
#endif

//External Power
#ifdef DUT_EXTERNAL_POWER_ENABLE
    DUT_motor.write(DUT_demand); //change DUT duty cycle based on demand
#endif

#ifdef LOAD_EXTERNAL_POWER_ENABLE
    load_motor.write(load_demand); //change load duty cycle based on demand
#endif

//set motor directions
    DUT_direction.write(DUT_input_direc);
    load_direction.write(load_input_direc);
}






