/*****************************************************************************/
/*Constants                                                                  */
/*****************************************************************************/

#define SCAP_MIN_VOLTAGE 0.607      //Switch to batt below this value (supercap)
#define SCAP_MAX_VOLTAGE 0.845      //Switch to batt above this value (supercap)
#define BATT_MIN_VOLTAGE 0.71       //Shutoff below this value (battery)
#define BATT_MAX_VOLTAGE 0.825      //Shutoff above this value (battery)

/*****************************************************************************/
/*Pin Setup                                                                  */
/*****************************************************************************/

DigitalOut relay(p23);          //Pin from which the relay coil is triggered

/*****************************************************************************/
/*Subroutines                                                                */
/*****************************************************************************/

//Checks battery and supercap voltages, returning 1 if the system needs to be shut down.
int checkBattVoltages() {
    //Check to see if batteries are out of proper voltage range
#ifdef DUT_BATT_ENABLE
    //check DUT batt
    if (v_DUT_batt_measure < BATT_MIN_VOLTAGE
            || v_DUT_batt_measure> BATT_MAX_VOLTAGE) { //check if voltage out of range
        relay = 1; //switch to cap
        return 1;
    }
#endif

#ifdef DUT_BATT_CAP_ENABLE
    //check DUT batt
    if (v_DUT_batt_measure < BATT_MIN_VOLTAGE
            || v_DUT_batt_measure> BATT_MAX_VOLTAGE) { //check if voltage out of range
        relay = 1; //switch to cap
        return 1;
    }
#endif

#ifdef LOAD_BATT_ENABLE
    //check load batt
    if ( v_load_batt_measure < BATT_MIN_VOLTAGE
            ||  v_load_batt_measure> BATT_MAX_VOLTAGE) { //check if voltage out of range
        return 1;
    }
#endif
    return 0; //return 0 if all batts are in the correct voltage range
}

#ifdef DUT_BATT_CAP_ENABLE
void superCapControl() {
    if (v_cap_measure <= SCAP_MIN_VOLTAGE && !regen
            || regen && v_cap_measure >= SCAP_MAX_VOLTAGE) { //if cap is drained, and regen is not engaged, switch back to battery. Or if cap is at its max voltage, and regen is engaged, switch to batt to prevent overcharging of cap.
        relay = 0; //switch to battery
    } else relay = 1; //switch to cap
}
#endif