#include "mbed.h"
#include "RTC.h"

PwmOut reds(D7);
PwmOut greens(D6);
PwmOut yellows(D5);
PwmOut blues(D4);

Serial pc(USBTX, USBRX);

// Circular buffers for serial TX and RX data - used by interrupt routines
const int buffer_size = 255;
// might need to increase buffer size for high baud rates
char tx_buffer[buffer_size+1];
char rx_buffer[buffer_size+1];
// Circular buffer pointers
// volatile makes read-modify-write atomic
volatile int tx_in=0;
volatile int tx_out=0;
volatile int rx_in=0;
volatile int rx_out=0;
// Line buffers for sprintf and sscanf
char tx_line[80];
char rx_line[80];

// State of the time setting
volatile int timeSetting = 0;
// Alarm state
volatile int alarmActive = 0;

void Rx_interrupt(void);
void minTick(void);
void alarmRoutine(void);
void lightSequence(void);
int redMs = 0;
int greenMs = 0;
int yellowMs = 0;
int blueMs = 0;

int main()
{
    
    pc.baud(9600);
    reds.period_ms(1);
    greens.period_ms(1);
    yellows.period_ms(1);
    blues.period_ms(1);

    reds.pulsewidth_us(redMs);
    greens.pulsewidth_us(greenMs);
    yellows.pulsewidth_us(yellowMs);
    blues.pulsewidth_us(blueMs);

    pc.attach(&Rx_interrupt, Serial::RxIrq);

    set_time(1256729737);  // Set RTC time to Wed, 28 Oct 2009 11:35:37

    RTC::attach(&minTick, RTC::Minute);
    while(1)sleep();
    return 0;
}

void Rx_interrupt()
{
    while (pc.readable()) {
        rx_buffer[rx_in] = pc.getc();
// Uncomment to Echo to USB serial to watch data flow
        pc.putc(rx_buffer[rx_in]);
        if(!rx_in) {
            if(rx_buffer[rx_in]=='a') {
                timeSetting = 1;
                printf("Enter alarm time as 'HH:MM' and press enter\r\n");
                rx_in = 0;
                return;
            } else if(rx_buffer[rx_in]=='t') {
                printf("Enter time and date as 'HH:MM:SS_dd/mm/yyyy' and press enter\r\n");
                timeSetting = 2;
                rx_in = 0;
                return;
            } else if(rx_buffer[rx_in]=='o') {
                printf("Lights off\r\n");
                redMs = 0;
                greenMs = 0;
                yellowMs = 0;
                blueMs = 0;
                rx_in = 0;
                timeSetting = 0;
                reds.pulsewidth_us(redMs);
                greens.pulsewidth_us(greenMs);
                yellows.pulsewidth_us(yellowMs);
                blues.pulsewidth_us(blueMs);
                alarmActive = 0;
                RTC::detach(RTC::Second);
                return;
            } else {
                if(!timeSetting) {
                    printf("Press 'a' to set alarm and 't' to set the time\r\n");
                    timeSetting = 0;
                    rx_in = 0;
                    return;
                }
            }
        } else {
            if(rx_buffer[rx_in]== '\r') {
                if(timeSetting == 1) {
                    int hours, minutes;
                    if(sscanf(rx_buffer, "%d:%d", &hours, &minutes)==2) {
                        printf("Alarm Stored\r\n");
                    } else {
                        printf("Error\r\n");
                    }
                    tm newTime;
                    newTime.tm_min = minutes;
                    newTime.tm_hour = hours;
                    RTC::alarm(&alarmRoutine, newTime);
                } else if(timeSetting == 2) {
                    int hours, minutes, seconds, day, month, year;
                    if(sscanf(rx_buffer, "%d:%d:%d_%d/%x/%d", &hours, &minutes,&seconds, &day, &month, &year)==6) {
                        printf("Time Stored: %d:%d:%d_%d/%x/%d\r\n", hours, minutes,seconds, day, month, year);
                        tm newTime;
                        newTime.tm_sec = seconds;
                        newTime.tm_min = minutes;
                        newTime.tm_hour = hours;
                        newTime.tm_mday = day;
                        newTime.tm_mon = month;
                        newTime.tm_year = year-1900;
                        
                        time_t setTime = mktime(&newTime);
                        set_time(setTime);
                    } else {
                        printf("Error\r\n");
                    }
                }
                rx_in = 0;
                timeSetting = 0;
                return;
            }
        }
    }
    rx_in = (rx_in + 1) % buffer_size;
}

void minTick()
{
    time_t seconds = time(NULL);
    printf("Time as a basic string = %s\r\n", ctime(&seconds));
    printf("Press 'a' to set alarm and 't' to set the time\r\n");
    //reds.pulsewidth_us(redMs);
    //redMs+=100;
    //if(!(redMs-1100)) {
    //    redMs = 0;
    //}
}
void alarmRoutine(){
    RTC::attach(&lightSequence, RTC::Second);
    printf("ALARM!!!\r\n");
}
void lightSequence(){
    if(redMs <= 1000){
        redMs+=3;
        reds.pulsewidth_us(redMs);
    }else if (yellowMs <= 1000){
        yellowMs+=3;
        yellows.pulsewidth_us(yellowMs);
    }else if (greenMs <= 1000){
        greenMs+=3;
        greens.pulsewidth_us(greenMs);
    }else if (blueMs <= 1000){
        blueMs+=1;
        blues.pulsewidth_us(blueMs);
    }else{
        alarmActive = 0;
        RTC::detach(RTC::Second);
    }
}