///////////////////////////////////////////////////////////////////////////////
// Integration des libs
#include "mbed.h"
#include "BMP085.h"
#include "SHTx/sht15.hpp"
#include "SDFileSystem.h"
#include "string.h"

///////////////////////////////////////////////////////////////////////////////
// Declaration des peripherique du systeme
BMP085 bmp085(p28, p27);
I2C i2clcd(p28, p27);
SHTx::SHT15 sensor(p18, p19);
DigitalIn bouton(p14);
SDFileSystem sd(p11, p12, p13, p14, "sd");
DigitalOut LED_1(LED1);
DigitalOut LED_2(LED2);
DigitalOut LED_3(LED3);
DigitalOut LED_4(LED4);
Serial xbee_orsay(p9, p10);
Serial pc(USBTX, USBRX);

///////////////////////////////////////////////////////////////////////////////
// Fonction qui recoit les caractere du Xbee
// Doit detecter d pour emettre un message
// Sinon ne fait rien
volatile char flag_xbee_orsay;
void recevoir_xbee_orsay(){
char bcar;
  while(xbee_orsay.readable()){
      bcar=xbee_orsay.getc();
      if(bcar=='a') flag_xbee_orsay=2;
      if(bcar=='z') flag_xbee_orsay=3;
  }
}

//////////////////////////////////////////////////////////////////////////////
// Variables utiles du systeme
int i = 0;
int t_mes = 1;
char mes1[30],mes2[30];

/////////////////////////////////////////////////////////////////////////////
// Programme principal
// La LED_1 s allume comme temoin
int main() {
    LED_1=1;
    xbee_orsay.baud(9600);
    xbee_orsay.attach(recevoir_xbee_orsay);
    mkdir("/sd/mydir", 0777);
    FILE*fp = fopen("/sd/mydir/mesures.txt", "w+");
    if(fp == NULL) {
        while(1);
    }
    sprintf(mes1,"%c[3e",27);
    i2clcd.write(0x48<<1,mes1,strlen(mes1));
    wait(0.005);
    LED_1=0;
    while(bouton == 1) {
        /////////////////////////////////////////////////////
        // Lecture des capteurs
        // La LED_2 s allume comme temoin
        LED_2=1;
        sensor.update();
        bmp085.update();
        i++;
        LED_2=0;
        /////////////////////////////////////////////////////
        // Ecriture donnees dans la carte memoire fprintf File
        fprintf(fp,"%d %6.2f %6.2f %6.2f %6.2f\r\n", i, bmp085.get_temperature(), sensor.getTemperature(), bmp085.get_pressure(), sensor.getHumidity());
        /////////////////////////////////////////////////////
        // On teste pour envoyer ou non sur le Xbee
        // La LED_4 s allume comme temoin
        LED_4=1;
        switch(flag_xbee_orsay){
            case 2 :
                xbee_orsay.printf("Debut transmission\r\n");
            case 1 :        
                xbee_orsay.printf("%d %6.2f %6.2f %6.2f %6.2f\r\n", i, bmp085.get_temperature(), sensor.getTemperature(), bmp085.get_pressure(), sensor.getHumidity());
                flag_xbee_orsay=1;
                break;
            case 3 : 
                flag_xbee_orsay=0;
                xbee_orsay.printf("Fin transmission\r\n");
                break;
            default:
                flag_xbee_orsay=0;
                break;
        }
        LED_4=0;
        /////////////////////////////////////////////////////
        // Impression sur le LCD  interface I2C
        // sprintf pour afficher dans une chaine caractere
        // La LED_3 s allume comme temoin
        LED_3=1;
        sprintf(mes2,"%6.1fhPA %5.1fC", bmp085.get_pressure(),bmp085.get_temperature());
        sprintf(mes1,"%c[j",27);
        i2clcd.write(0x48<<1,mes1,strlen(mes1));
        wait(0.01);
        i2clcd.write(0x48<<1,mes2,strlen(mes2));
        wait(0.01);
        sprintf(mes1,"%c[1;0H",27);
        i2clcd.write(0x48<<1,mes1,strlen(mes1));
        wait(0.01);
        sprintf(mes2,"%5.1f%c %5.1fC", sensor.getHumidity(),'%',sensor.getTemperature());
        i2clcd.write(0x48<<1,mes2,strlen(mes2));
        LED_3=0;
        /////////////////////////////////////////////////////
        // On attend pour completer une seconde
        wait(t_mes-0.05);
    }
    fclose(fp);
    while(1);
}