#include "preferences.h"

DigitalOut relaisSelectionRotation1(p21);
DigitalOut relaisSelectionRotation2(p22);
DigitalOut relaisSelectionPression(p24);
DigitalOut relaisLectureCapteurs(p8);

AnalogIn capteurLumiereHaut(p15);
AnalogIn capteurLumiereBas(p20);

float largeur_impulsion_relais = 0.08;
float seuil_capteurs_lumiere = 0.5;

void thread_checkCapteurs()
{
    AnalogIn capteurLumiere1(p15); // - longueur 3
    AnalogIn capteurLumiere2(p16); // - signal chauffe
    AnalogIn capteurLumiere3(p17); // défaut grain
    AnalogIn capteurLumiere4(p18); // symbole bas gauche
    AnalogIn capteurLumiere5(p19); // longueur 3 ---> BUG (valeur divisée par deux ?)
    AnalogIn capteurLumiere6(p20); // - intensité 3
    DigitalOut relaisUtilisationCapteurs(p8);
    DigitalIn capteurEau(p11);
    capteurEau.mode(PullUp);

    relaisUtilisationCapteurs = 1;
    
    while(1)
    {
        printf("1:%.3f\t 2:%.3f 3:%.3f\t 4:%.3f\t 5:%.3f\t 6:%.3f\t EAU:%d\n\r", capteurLumiere1.read(), capteurLumiere2.read(), capteurLumiere3.read(), capteurLumiere4.read(), capteurLumiere5.read(), capteurLumiere6.read(), capteurEau.read());
    }
}

int getPreferenceLongueur()
{
    float val;
    int nombre_incrementations = 0;
    
    do // on se positionne sur le capteur de lumière
    {
        val = getValeurCapteurLumiere(capteurLumiereHaut);
        if(val > seuil_capteurs_lumiere)
        {
            simulerSelectionLongueur();
            nombre_incrementations ++;
            
            if(nombre_incrementations == 5)
                return -1; // aucun voyant n'est allumé
        }
    } while(val > seuil_capteurs_lumiere);
    
    switch(nombre_incrementations) // on retourne sur la position initiale
    {
        case 0:
            // cas où l'on se trouve déjà sur le capteur de lumière
            break;
        
        case 1:
            simulerSelectionPrecedenteLongueur();
            break;
        
        case 2:
            simulerSelectionPrecedenteLongueur();
            simulerSelectionPrecedenteLongueur();
            break;
        
        case 3:
            simulerSelectionLongueur();
            simulerSelectionLongueur();
            break;
        
        case 4:
            simulerSelectionLongueur();
            break;
    }
    
    int selection = (3 + 5 - nombre_incrementations) % 5;
    if(selection == 0)
        return 5;
    
    else
        return selection;
}

int getPreferenceIntensite()
{
    float val;
    int rang = -1, selection;
    
    for(int i = 0 ; i < 6 ; i ++)
    {
        val = getValeurCapteurLumiere(capteurLumiereBas);
        if(val < seuil_capteurs_lumiere)
        {
            rang = i;
        
            if(i == 0)
                break;
        }
        
        simulerSelectionIntensite();
    }
    
    if(rang == -1)
        return -1;
    
    selection = (6 - rang + 3) % 6;
    if(selection == 0)
        return 6;
    
    else
        return selection;
}

int setPreferenceLongueur(int preference)
{
    float val;
    
    do // on se positionne sur le capteur de lumière
    {
        val = getValeurCapteurLumiere(capteurLumiereHaut);
        if(val > seuil_capteurs_lumiere)
            simulerSelectionLongueur();
    } while(val > seuil_capteurs_lumiere);
    
    switch(preference) // puis on atteind la sélection souhaitée, au plus tot
    {
        case 1:
            simulerSelectionPrecedenteLongueur();
            simulerSelectionPrecedenteLongueur();
            break;
            
        case 2:
            simulerSelectionPrecedenteLongueur();
            break;
            
        case 3:
            // On y est déjà
            break;
        
        case 4:
            simulerSelectionLongueur();
            break;
        
        case 5:
            simulerSelectionLongueur();
            simulerSelectionLongueur();
            break;
     }
    
    return 0;
}

int setPreferenceIntensite(int preference)
{
    float val;
    
    do
    {
        val = getValeurCapteurLumiere(capteurLumiereBas);
        if(val > seuil_capteurs_lumiere)
            simulerSelectionIntensite();
    } while(val > seuil_capteurs_lumiere);
    
    for(int i = 0 ; i < (3 + preference) % 6 ; i ++)
        simulerSelectionIntensite();
    
    return 0;
}

float getValeurCapteurLumiere(AnalogIn capteurLumiere)
{
    relaisLectureCapteurs = 1;
    wait(0.01);
    float valeur_capteur = capteurLumiere.read();
    relaisLectureCapteurs = 0;
    wait(0.01);
    return valeur_capteur;
}

void simulerSelectionLongueur()
{
    relaisSelectionRotation1 = 1;
    wait(largeur_impulsion_relais / 2);
    relaisSelectionRotation2 = 1;
    wait(largeur_impulsion_relais / 2);
    relaisSelectionRotation1 = 0;
    wait(largeur_impulsion_relais / 2);
    relaisSelectionRotation2 = 0;
    wait(1.5*largeur_impulsion_relais);
}

void simulerSelectionPrecedenteLongueur()
{
    relaisSelectionRotation2 = 1;
    wait(largeur_impulsion_relais / 2);
    relaisSelectionRotation1 = 1;
    wait(largeur_impulsion_relais / 2);
    relaisSelectionRotation2 = 0;
    wait(largeur_impulsion_relais / 2);
    relaisSelectionRotation1 = 0;
    wait(1.5*largeur_impulsion_relais);
}

void simulerSelectionIntensite()
{
    relaisSelectionPression = 1;
    wait(largeur_impulsion_relais);
    relaisSelectionPression = 0;
    wait(largeur_impulsion_relais);
}
