#include "mbed.h"
#include "rtos.h"
#include "cafe.h"
#include "camera.h"
#include "capteur_tasse.h"
#include "eau.h"
#include "ethernet.h"
#include "led.h"
#include "machine.h"
#include "preferences.h"
#include "purge.h"
#include "ecran_lcd.h"
#include "intelligence.h"

#define TIMEOUT_DETECTION   20.0

int main()
{
    //thread_checkCapteurs();
    /*if(getPreferenceIntensite() == -1)
        allumerMachine();*/
    //printf("%d\n\r", getPreferenceIntensite());
    
    Thread threadEcran(thread_ecran);
    wait(1);
    afficherAuCentreDeLEcran("Demarrage", "du systeme");
    
    Timer t;
    char nom_utilisateur[25];
    DigitalIn boutonPoussoir(p12);
    int preference_longueur = 0, preference_intensite = 0;
    bool detection_visage = false, utilisateur_reconnu = false;
    wait(1);
    
    if(preparationEthernet())
    {
        checkContenanceReserveEau(true);
        wait(1); // Pour laisser l'affichage du message
        
        if(initialiserCamera())
        {
            wait(1); // Pour laisser l'affichage du message
            while(boutonPoussoir.read() != 1) // Arret du système avec pression sur BP
            {
                t.reset();
                
                do
                {
                    checkPurge();
                    checkCafe();
                    checkContenanceReserveEau(false);
                    afficherAuCentreDeLEcran("Pret a", "vous servir");
                    
                    if(boutonPoussoir.read() == 1)
                        break;
                    
                    // Recherche d'un visage en permanence
                    detection_visage = detecterUtilisateur(&utilisateur_reconnu, 
                                                            nom_utilisateur, 
                                                            &preference_intensite, 
                                                            &preference_longueur);
                } while(!detection_visage);
                
                if(boutonPoussoir.read() == 1)
                    break;
                    
                //async_desactiverDetectionVisage();
                // Lancement d'une détection en boucle
                //Thread threadDetectionVisage(thread_detection_visage);
                //wait(3);
                
                if(utilisateur_reconnu)
                {
                    afficherAuCentreDeLEcran("Bonjour", nom_utilisateur);
                    setPreferenceLongueur(preference_longueur);
                    setPreferenceIntensite(preference_intensite);
                    wait(3);
                    
                    t.start();
                    afficherAuCentreDeLEcran("Veuillez changer", "vos preferences", "puis placer", "votre tasse");
                    while(/*async_visageDetecte() && */!tasseEnPlace() && t.read() < TIMEOUT_DETECTION);
                    t.stop();
                    
                    if(t.read() >= TIMEOUT_DETECTION)
                        continue;
                        
                    /*if(!async_visageDetecte())
                        continue;*/
                        
                    // Sinon, c'est que l'utilisateur a placé sa tasse
                    
                    // On lance la prise de photos en continu pour enrichir la base
                    //async_lancerPriseEtEnvoiPhotosEnContinu();
                    
                    // On lance la production de café
                    faireUnCafe();
                    
                    afficherAuCentreDeLEcran("Sauvegarde de", "vos preferences");
                    communiquerAuServeurPreferencesUtilisateur(getPreferenceIntensite(), getPreferenceLongueur());
                    wait(2);
                    afficherAuCentreDeLEcran("Retirez", "votre tasse");
                    
                    // On arrete la prise de photos et on en informe le serveur
                    //async_stopperPriseEtEnvoiPhotosEnContinu();
                    
                    // On attend que l'utilisateur retire sa tasse
                    while(tasseEnPlace());
                }
                
                else
                {
                    t.start();
                    afficherAuCentreDeLEcran("Nouvel", "utilisateur", "Veuillez placer", "votre tasse");
                    while(/*async_visageDetecte() && */!tasseEnPlace() && t.read() < TIMEOUT_DETECTION);
                    t.stop();
                    
                    if(t.read() >= TIMEOUT_DETECTION)
                        continue;
                        
                    /*if(!async_visageDetecte())
                        continue;*/
                        
                    // Sinon, c'est que l'utilisateur a placé sa tasse
                    
                    // On lance la prise de photos en continu pour enrichir la base
                    //async_lancerPriseEtEnvoiPhotosEnContinu();
                    
                    afficherAuCentreDeLEcran("Faites votre", "selection", "puis", "validez");
                    while(!capteurChauffeClignotant());
                    
                    afficherAuCentreDeLEcran("Merci de", "patienter");
                    while(capteurChauffeClignotant()); // on attend la fin de café
                    
                    // On recherche les préférences de l'utilisateur et on les communique au serveur
                    afficherAuCentreDeLEcran("Lecture de", "vos preferences");
                    if(communiquerAuServeurPreferencesUtilisateur(getPreferenceIntensite(), getPreferenceLongueur()))
                    {
                        afficherAuCentreDeLEcran("Echec de ", "sauvegarde");
                        wait(1);
                    }
                    
                    // On arrete la prise de photos et on en informe le serveur
                    //async_stopperPriseEtEnvoiPhotosEnContinu();
                    
                    // On attend que l'utilisateur retire sa tasse
                    afficherAuCentreDeLEcran("Retirez", "votre tasse");
                    while(tasseEnPlace());
                }
            }
        }
        
        deconnexionEthernet();
    }
    
    return 0;
}
