#include "machine.h"

DigitalOut relaisMachine(p5);
AnalogIn capteurLumiereChauffe(p16);
DigitalOut relaisLectureCapteursMachine(p8);

void attendreFinDePreparation()
{
    while(!capteurChauffeClignotant());
    while(capteurChauffeClignotant());
}

bool machineEteinte()
{
    // La machine est considérée comme éteinte si le capteur de chauffe ne clignote
    // pas et si les voyant d'intensité sont éteints
    return !capteurChauffeClignotant() && getPreferenceIntensite() == -1;
}

void allumerMachine()
{
    relaisMachine = 1;
    relaisLectureCapteursMachine = 1;
    
    // On attend la fin de la chauffe
    while(capteurChauffeClignotant());
    
    relaisLectureCapteursMachine = 0;
    
    // La machine est prete
    relaisMachine = 0;
    wait(0.2);
}

bool capteurChauffeClignotant()
{
    return capteurChauffeClignotant(0.5, 0.5);
}

bool capteurChauffeClignotant(float seuil_min, float seuil_max)
{
    Timer t;
    t.start();
    
    int nb = 0;
    
    float valeur_actuelle, valeur_min = 1.0, valeur_max = 0.0;
    
    wait(0.2); // on attend un état stable
    while(t.read() < 1.0)
    {
        nb ++;
        valeur_actuelle = capteurLumiereChauffe.read();
        wait(0.02);
        
        if(valeur_min > valeur_actuelle)
            valeur_min = valeur_actuelle;
        
        if(valeur_max < valeur_actuelle)
            valeur_max = valeur_actuelle;
    }
        
    printf("Min : %.3f\t\tMax : %.3f\t\t%d\r\n", valeur_min, valeur_max, nb);
        
    t.stop();
    
    return valeur_min < seuil_min && valeur_max > seuil_max;
}

void eteindreMachine()
{
    relaisMachine = 1;
    wait(1);
    relaisLectureCapteursMachine = 1;
    
    // On attend la fin de la chauffe
    while(capteurChauffeClignotant());
    
    relaisLectureCapteursMachine = 0;
    relaisMachine = 0;
    wait(0.2);
}

bool machineOccupee()
{
    return getPreferenceIntensite() == -1;
}
