#include "mbed.h"
#include "rtos.h"
#include "cafe.h"
#include "camera.h"
#include "capteur_tasse.h"
#include "eau.h"
#include "ethernet.h"
#include "led.h"
#include "machine.h"
#include "preferences.h"
#include "purge.h"
#include "ecran_lcd.h"
#include "intelligence.h"

// Variable globale partagée entre threads
bool p_detection_visage;
bool p_prendre_et_envoyer_photos_en_continu;

bool communiquerAuServeurPreferencesUtilisateur(int preference_intensite, int preference_longueur)
{
    printf("\tCommunication des prefs au serveur : %d | %d\n\r", preference_intensite, preference_longueur);
    char requete[9], reponse[10];
    sprintf(requete, "SAVE %d %d", preference_intensite, preference_longueur);
    printf("\tTentative connexion socket\n\r");
    if(connexionSocket())
    {
        envoyerChaineSocket(requete, 9, reponse, 10);
        printf("\tEnvoi de [%s]\n\r", requete);
        printf("\tTentative deconnexion socket\n\r");
        deconnexionSocket();
        return strcmp("SAVE OK", reponse);
    }
    return false;
}

/*bool detecterUtilisateur()
{
    return true;
}*/




void async_desactiverDetectionVisage()
{
    p_detection_visage = false;
}

void async_activerDetectionVisage()
{
    p_detection_visage = true;
}

bool async_visageDetecte()
{
    return p_detection_visage;
}

void thread_detection_visage(void const *args)
{
    do
    {
        //p_detection_visage = detecterUtilisateur();
    } while(p_detection_visage);
}

void communiquerAuServeurEmissionsPhotos()
{

}

void communiquerAuServeurFinEmissionPhotos()
{

}

void thread_prendreEtEnvoyerPhotosEnContinu(void const *args)
{
    // Le serveur se prépare à recevoir plusieurs photos
    communiquerAuServeurEmissionsPhotos();
    
    while(p_prendre_et_envoyer_photos_en_continu)
    {
        // La machine prend une photo et l'envoi en traitement au serveur
        
    }
    
    // On informe le serveur de la fin de prise de photos
    communiquerAuServeurFinEmissionPhotos();
}

void async_lancerPriseEtEnvoiPhotosEnContinu()
{
    p_prendre_et_envoyer_photos_en_continu = true;
    Thread thread_PEEPEC(thread_prendreEtEnvoyerPhotosEnContinu);
}

void async_stopperPriseEtEnvoiPhotosEnContinu()
{
    p_prendre_et_envoyer_photos_en_continu = false;
}

void thread_check(void const *args)
{
    checkContenanceReserveEau(true); // initialisation
    
    while(1)
    {
        checkPurge();
        checkCafe();
        checkContenanceReserveEau(false);
        wait(0.5);
    }
}
