#include "ecran_lcd.h"

TextLCD ecranLCD(p30, p26, p25, p27, p28, p29); // rs, e, d4-d7
char message_ecran_1_haut[50], message_ecran_1_bas[50], message_ecran_2_haut[50], message_ecran_2_bas[50];
bool afficher_double_message, mettre_a_jour_ecran;

void thread_ecran(void const *args)
{
    Timer t;
    mettre_a_jour_ecran = false;
    wait(1);
    
    while(1)
    {
        if(mettre_a_jour_ecran)
        {
            ecranLCD.cls();
            mettre_a_jour_ecran = false;
            
            if(!afficher_double_message)
            {
                afficherSurUneLigne(message_ecran_1_haut, 1);
                afficherSurUneLigne(message_ecran_1_bas, 2);
            }
            
            else
            {
                t.reset();
                t.start();
                bool mise_a_jour_1 = false, mise_a_jour_2 = false;
                
                while(!mettre_a_jour_ecran)
                {
                    if(t.read() < 1.5)
                    {
                        if(!mise_a_jour_1)
                        {
                            ecranLCD.cls();
                            afficherSurUneLigne(message_ecran_1_haut, 1);
                            afficherSurUneLigne(message_ecran_1_bas, 2);
                            mise_a_jour_1 = true;
                        }
                    }
                    
                    else if(t.read() > 1.5*2)
                    {
                        t.reset();
                        mise_a_jour_1 = false;
                        mise_a_jour_2 = false;
                    }
                    
                    else
                    {
                        if(!mise_a_jour_2)
                        {
                            ecranLCD.cls();
                            afficherSurUneLigne(message_ecran_2_haut, 1);
                            afficherSurUneLigne(message_ecran_2_bas, 2);
                            mise_a_jour_2 = true;
                        }
                    }
                }
                
                t.stop();
            }
            
        }
    }
}

void afficherSurUneLigne(const char* texte_brut, int ligne)
{
    int i;
    char texte[17];
    for(i = 0 ; i < 16 ; i ++)
        texte[i] = texte_brut[i];
    
    texte[i] = '\0';
    
    int nb_espaces_a_ajouter = (ecranLCD.columns() - strlen(texte)) / 2;

    if(nb_espaces_a_ajouter < 0)
        nb_espaces_a_ajouter = 0;

    ecranLCD.locate(nb_espaces_a_ajouter, ligne - 1);
    ecranLCD.printf(texte);

    if(ligne == 1)
        printf("Affichage ecran : ");

    printf("%s ", texte);

    if(ligne == 2)
        printf("\n\r");
}

/* Surement deprecated */
void faireDefilerSurEcran(const char* texte, int vitesse)
{
    int k = 0;
    
    for(int i = 0 ; i < 999 ; i ++)
    {
        ecranLCD.cls();
    
        for(int j = 0 ; j < strlen(texte) - k ; j ++)
            ecranLCD.printf("%c", texte[k + j]);
        
        for(int j = strlen(texte) - k ; j < 15 - k ; j ++)
            ecranLCD.printf(" ");
        
        for(int j = 15 - k ; j < 15 ; j ++)
            ecranLCD.printf("%c", texte[j - (15 - k)]);
        
        wait(0.3);
        
        k ++;
        
        if(k == 15)
            k = 0;
    }
}

void afficherAuCentreDeLEcran(const char* texte_haut, const char* texte_bas)
{
    sprintf(message_ecran_1_haut, "%s", texte_haut);
    sprintf(message_ecran_1_bas, "%s", texte_bas);
    sprintf(message_ecran_2_haut, "");
    sprintf(message_ecran_2_bas, "");
    afficher_double_message = false;
    mettre_a_jour_ecran = true;
}

void afficherAuCentreDeLEcran(const char* texte_1_haut, const char* texte_1_bas, const char* texte_2_haut, const char* texte_2_bas)
{
    sprintf(message_ecran_1_haut, "%s", texte_1_haut);
    sprintf(message_ecran_1_bas, "%s", texte_1_bas);
    sprintf(message_ecran_2_haut, "%s", texte_2_haut);
    sprintf(message_ecran_2_bas, "%s", texte_2_bas);
    afficher_double_message = true;
    mettre_a_jour_ecran = true;
}

void afficherAuCentreDeLEcran(int nombre1, int nombre2)
{
    char s1[20], s2[20];
    sprintf(s1, "%i", nombre1);
    sprintf(s2, "%i", nombre2);
    afficherAuCentreDeLEcran(s1, s2);
}
