#include "camera.h"

LocalFileSystem local("local");
Camera_LS_Y201 camera(p13, p14);

typedef struct work
{
    FILE *fp;
} work_t;
 
work_t work;

void acallback_func(int done, int total, uint8_t *buf, size_t siz, char *reponse)
{
    // Fonction de callback pour écriture de l'image
    // buf : pointeur sur un buffer
    // siz : taille tu buffer
    //printf("callback : buffer de taille %d\r\n", siz);
    //fwrite(buf, siz, 1, work.fp);
    
    
    envoyerChaineSocket((char*)buf, siz, reponse, 30);
    //printf("callback response : %s\r\n", reponse);
    
    
    //static int n = 0;
    //int tmp = done * 100 / total;
    
    //if(n != tmp)
    //{
    //    n = tmp;
    //    printf("Writing...: %3d%%\r\n", n); 
    //}
}

int acapture(Camera_LS_Y201 *cam, char *reponse)
{
    // Prise de l'image
    if(cam->takePicture() != 0)
        return -1;
    
    printf("\tPhoto prise\r\n");
    //afficherAuCentreDeLEcran("Photo prise", "wesh");
 
    // Ouverture du fichier
    //work.fp = fopen(nom_fichier, "wb");
    //if(work.fp == NULL)
    //    return -2;
 
    // Lecture du contenu
    //printf("%s\r\n", nom_fichier);
    
    if(cam->readJpegFileContent(acallback_func, envoyerChaineSocket, reponse) != 0)
    {
        //fclose(work.fp);
        return -3;
    }
    
    //fclose(work.fp);
    wait(1);
 
    // Fin de la prise d'image
    cam->stopTakingPictures();
 
    return 0; // Retourne donc 0 en cas de succès
}

bool initialiserCamera()
{
    int initCam;
    
    do
    {
        printf("Reset CAMERA\r\n");
        initCam = camera.reset();
    } while(initCam != 0);
    
    if(initCam != 0)
    {
        printf("Echec de l'initialisation caméra %d\r\n", initCam);
        afficherAuCentreDeLEcran("Echec init", "camera");
        return false;
    }
    
    else
    {
        printf("Initialisation caméra OK.\r\n");
        afficherAuCentreDeLEcran("Initialisation", "camera : ok");
        return true;
    }
}

bool detecterUtilisateur(bool *utilisateur_reconnu, char* nom_utilisateur, int* preference_intensite, int *preference_longueur)
{
    printf("\tDébut détection utilisateur\r\n");
    char reponse[30], requete[10];
    int taille_reponse = 0;
    
    if(connexionSocket())
    {
        sprintf(requete,"PHOTO");
        
        // Envoi de "RECO". Réception de "RECO OK"
        envoyerChaineSocket(requete, sizeof(requete), reponse, 30); 
        //printf("Reponse %s : %s\r\n\r", requete, reponse);
        
        int r = acapture(&camera, reponse);

        if(r != 0)
            printf("IMG_TEST:NG. (code=%d)\r\n", r);
        
        /*else
            printf("IMG_TEST:OK.\r\n");*/
        
        // Parsing des parametres depuis la réponse
        
        /* CHAINES A RECEVOIR :
            USER=Leo 2 3            // cas Léo reconnu
            USER=Simon 3 4          // cas Simon reconnu
            USER-                  // cas aucun visage
            USER?userTest          // cas visage non reconnu
        */
        
        //sprintf(reponse, "USER?userTest");
        //sprintf(reponse, "USER=Simon 3 4");
        printf("Chaine d'identification : [%s]\n\r", reponse);
        
        if(reponse[4] == '-')
        {
            deconnexionSocket();
            return false;
        }
        
        *utilisateur_reconnu = (reponse[4] != '?');
        taille_reponse = strlen(reponse);
        
        int j;
        for(j = 5 ; j < taille_reponse && reponse[j] != ' ' ; j++)
            nom_utilisateur[j - 5] = reponse[j];
        nom_utilisateur[j - 5] = '\0';
        
        *preference_intensite = reponse[taille_reponse - 3] - '0';
        *preference_longueur = reponse[taille_reponse - 1] - '0';
        
        deconnexionSocket();
        return true;
    }
    
    else
    {
        printf("\tErreur d'ouverture du socket\r\n\r");
        return false;
    }
}