#include "mbed.h"
#include "thermistor.h"
 
Thermistor::Thermistor(PinName ThermistorPin, int NominalRes, int Beta, int SeriesResistor) : thermistorpin(ThermistorPin), nominalres(NominalRes), beta(Beta), seriesresistor(SeriesResistor) {
    init();
}
 
void Thermistor::init() {
    //defaults:
    //beta = 3950 // The beta coefficient of the thermistor (usually 3000-4000)
    //seriesresistor = 4700 //value of the second resistor - seriesresistor
}
 
void Thermistor::get_temperature() {
    int temperaturenominal = 25; //temperature when the resistance is measured
    a = thermistorpin.read_u16(); // Read 16bit Analog value
    res = (float) seriesresistor / ((65536.0 / a) - 1); // get resistance of the thermistor
    steinhart = res / nominalres;  // (R/Ro)
    steinhart = log(steinhart);                 // ln(R/Ro)
    steinhart /= beta;                  // 1/B * ln(R/Ro)
    steinhart += 1.0 / (temperaturenominal + 273.15);   // + (1/To)
    steinhart = 1.0 / steinhart; //invert
    temp = steinhart - 273.15;           // to celsius
}
 
float Thermistor::temperature() {
    get_temperature();
    return temp;
}

float Thermistor::resistance() {
    get_temperature();
    return res;
}