/** Measuring temperature with thermistor
 *
 * Example of use:
 * @code
 * #include "mbed.h"
 * #include "thermistor.h"
 *
 * Serial pc(USBTX, USBRX); // serial communication
 *
 * int main() {
 *     Thermistor my_thermistor(A5, 10000, 3950, 4700); // instantiate the sensor object (on pin A5, nominal resistance is 10kOhms, beta coefficient is 3950 and value of the sacond resistor is 4,7kOhms
 *     while(1) {
 *         pc.printf("Temperature: %5.1f celsius degrees\r", my_thermistor.temperature());
 *         pc.printf("Resistance: %5.1f ohms\r", my_thermistor.resistance());
 *         wait_ms(1000);
 *     }
 * }
 * @endcode
 */
class Thermistor
{

public:

    /**
     * @param thermistorpin mbed analog pin to which the thermistor is connected to
     * @param nominalres resistance of thermistor at 25 celsius degrees
     * @param beta beta coefficient of thermistor
     * @param seriesresistor value of the resistor connecter with thermistor
     */
    Thermistor(PinName thermistorpin, int nominalres, int beta, int seriesresistor);

    /**
     * @returns temperature in celsius degrees
     */
    float temperature();
    void get_temperature();
    /**
     * @returns resistance of thermistor
     */
    float resistance();
    void init();

private:

    int temperaturenominal;
    AnalogIn thermistorpin;
    int nominalres;
    int beta;
    int seriesresistor;
    float temp;
    float res;
    float steinhart;
    int a;

};