#include "stm32f103c8t6.h"
#include "mbed.h"
#include "USBSerial.h"
#include "thermistor.h"
#include "HMC5883L.h"
#include "DHT11.h"

DigitalOut led(PC_13);
Thermistor my_thermistor(ADC_TEMP, 10000, 3950, 4700);
HMC5883L wind_direction(I2C_SDA, I2C_SCL);
DHT11 temphum(PB_12);

int main()
{
    confSysClock();
    USBSerial usb(0x1f00, 0x2012, 0x0001,  false); //init usb serial
    
    usb.printf("\nReading temperature from internal sensor in processor\n");
    while(1) {
        temphum.readData();
        usb.printf("Thermistor = %f\n", my_thermistor.temperature());
        usb.printf("Heading = %f\n", wind_direction.getHeadingXYDeg());
        usb.printf("Temperature DHT11 = %d\n", temphum.readTemperature());
        usb.printf("Humidity DHT11 = %d\n", temphum.readHumidity());
        led = !led;
        wait(1.0);
    }
}
