#include "mbed.h"
#include "LIS3DSH.h"
DigitalOut myledG(PD_12);
DigitalOut myledO(PD_13);
DigitalOut myledR(PD_14);
DigitalOut myledB(PD_15);
InterruptIn button(PA_0);
Serial uart(PC_6,PC_7);

LIS3DSH acc(PA_7, PA_6, PA_5, PE_3);
 //          mosi, miso, clk , cs
 
char buttonDetectFlag=0;
void buttonISr(){
    buttonDetectFlag=1;
    }
int main() {
    uart.baud(9600);
    button.fall(&buttonISr);
     int16_t X, Y, Z;    //signed integer variables for raw X,Y,Z values
    float roll, pitch;  //float variables for angles
    
    if(acc.Detect() != 1) {
        uart.printf("LIS3DSH Acceleromoter not detected!\n");
        while(1){ };
    }
    
    while(1) {
        wait(0.5);  
        static char counter=0;
        acc.ReadData(&X, &Y, &Z);           //read X, Y, Z values
        acc.ReadAngles(&roll, &pitch);      //read roll and pitch angles
        uart.printf("X: %d  Y: %d  Z: %d\n", X, Y, Z);
        uart.printf("Roll: %f   Pitch: %f\n", roll, pitch);
        
        if(buttonDetectFlag)
        {
            buttonDetectFlag=0;
            if(counter==0)
                myledG=!myledG;
            else if(counter==1)
                myledO=!myledO;
            else if(counter==2)
                myledR=!myledR;
            else if(counter==3)
                myledB=!myledB;
            counter++;
           if(counter>=4)
            counter=0;         
        }
    }
}
