#include "mbed.h"


#define nSerialPatch    /* compiler switch for workaround */

DigitalOut myled(LED1);

Serial     stComX(USBTX,USBRX);/*
* Description :  UART communicatin (Txd(D1)/Rxd(D0)) USART2 to serial PC COM-Port  
*/

unsigned char  bSizeData; /*
* Description : number of transmission data
*/

unsigned char *pUartData; /*
* Description : pointer to data
*/

unsigned char abString[] = "Hello World!\n\r"; /*
* Description : test string
*/

/* new data to UART */
unsigned char SYS_vStartComX( unsigned char *pData, unsigned char bSize ){    /* new data to UART */
    unsigned char i;
    if(bSizeData) i = 0; 
    else{
        bSizeData = bSize;                                  /* number of transmission data */
        pUartData = pData;                      
        stComX.putc(*pUartData);                            /* first data */
        pUartData++;
        bSizeData--;
#ifdef nSerialPatch
        USART2->CR1 |= USART_CR1_TXEIE;                     /* enable TXE interrupt */
#endif
        i = 1;
        }
    return i;
    }

/* TX ISR */
void vIsrTxComX( void ){                       
    if(stComX.writeable()){                                 /* check stComX */
        if(bSizeData){                                      /* further data available */
            stComX.putc(*pUartData);                        /* next data */
            pUartData++;
            bSizeData--;
            }
#ifdef nSerialPatch
        else{
            USART2->CR1 &= ~USART_CR1_TXEIE;                /* disable TXE interrupt */
            }
#else
        stComX.putc('e');
#endif
        }
    }
    
/* RX ISR */
void vIsrRxComX( void ){                        
    volatile unsigned char i;
    if(stComX.readable()){                                  /* check stComX */
        i = (unsigned char)stComX.getc();
        if(i == 'n'){
            SYS_vStartComX( abString, sizeof(abString)-1);
            }
        }
    }

int main() {
/*  establish serial interrupts */
    stComX.attach(&vIsrRxComX, Serial::RxIrq); 
    stComX.attach(&vIsrTxComX, Serial::TxIrq);

/* endless loop */
    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
