/***************************************************************************
* Titel        : main.c
*
* Description  : Labormodul "DIBI"
*
* Revision List:
  --------------------------------------------------------------------------
  Date     | Author          | Change
  --------------------------------------------------------------------------
  16.11.15 | J. Altenburg    | Ersterstellung
  --------------------------------------------------------------------------
           |                 |
  ----------------------------------------------------------------------------
****************************************************************************/
#include "mbed.h"
#include "cdef.h"

/* Vereinbarungen zu den Tasteneingängen */
DigitalIn   pinS1(A1);
DigitalIn   pinS2(A2);
DigitalIn   pinS3(A3);

//BusOut      bLedShield(D13, D12, D11, D10);
BusOut      bLedShield(D10, D11, D12, D13);

/* Anschlüsse der Schieberegister */
DigitalOut  pinSdo(PA_9);
DigitalOut  pinSck(PA_8);
DigitalOut  pinLoad(PB_5);

/* ISR */
Ticker      stTimer;

/***************************************************************************
*   Defines und Makros                                                       *
***************************************************************************/
//#define nTEMP               /* Compilerschalter */ 


#define nTastShort    4     /* Taste 50 Millisekunden gedrückt */    
#define nTastLong   150     /* Taste 1.5 Sekunden gedrückt */ 

#define n300ms          3

#define nDsp100ms       1
#define nDsp500ms       5
#define nDsp1Sek        10
#define nDsp2Sek        20          

#define nOn             0
#define nOff            1

#define nSegA           0x01
#define nSegB           0x02
#define nSegC           0x04
#define nSegD           0x08
#define nSegE           0x10
#define nSegF           0x20
#define nSegG           0x40
#define nSegH           0x80


#define nZiffer0    ~(nSegA | nSegB | nSegC | nSegD | nSegE | nSegF)
#define nZiffer1    
#define nZiffer2    
#define nZiffer3    
#define nZiffer4    
#define nZiffer5    
#define nZiffer6    
#define nZiffer7    
#define nZiffer8    
#define nZiffer9    
#define nZifferA    
#define nZifferB    
#define nZifferC    
#define nZifferD    
#define nZifferE    
#define nZifferF    
#define nZifferOff   

enum{ 
     enDoNothing = 0
    ,enDisplay
    };



byte bIdx; /*
* Description : Index auf Ausgabe
*/

int8 iDir; /*
* Description : Zählrichtung
*/

byte bBlinkTime; /*
* Description : 
*/

byte bS1Timer; /*
* Description : Timer für Taste S1
*/

byte bS2Timer; /*
* Description : Timer für Taste S2
*/

byte bS3Timer; /*
* Description : Timer für Taste S3
*/

byte bDisplayState; /*
* Description : Zustandsautomat Blinker
*/

word wSerial; /*
* Description : serielles Ausgaberegister
*/

byte bDspTime; /*
* Description : Displaytimer
*/

byte bDspTimeValue; /*
* Description : Zählzeitvorgabe
*/

byte bBargraph; /*
* Description : Bargraph anzeigen 
*/

byte bBarBlink; /*
* Description : Bargraphblinker
*/

/* Bitmuster */
const byte abBargraph[] = {~Bit0, ~(Bit0|Bit1), ~(Bit0|Bit1|Bit2), ~(Bit0|Bit1|Bit2|Bit3), 0x0f};
const byte abZiffer[] = {nZiffer0, nZiffer1, nZiffer2, nZiffer3, nZiffer4, nZiffer5, nZiffer6, nZiffer7, nZiffer8, nZiffer9, nZifferA, nZifferB, nZifferC, nZifferD, nZifferE, nZifferF, nZifferOff};
const byte abDspTime[] = {nDsp100ms, nDsp500ms, nDsp1Sek, nDsp2Sek};


/* Tastenabfrage */
void vTasteS1( void ){
    if(pinS1 == 0){                             /* User-Taste gedrückt */
        if(bS1Timer < nTastLong+1){             /* Abfrage max. bis Taste lange gedrückt */
            if(bS1Timer == nTastShort){         /* Taste "kurz gedrückt" erkannt */
#if 1
//...
#endif
                }
            if(bS1Timer == nTastLong){          /* Taste "lange gedrückt" erkannt */ 
                //bBlinkState = enBlinkLong;
                }
            bS1Timer++;
            }
        }
    else{                                       /* Taste nicht gedrückt */ 
        if(bS1Timer >= nTastShort){             /* Taste wurde bereits erkannt */
#if 0

#endif
            }
        bS1Timer = 0;
        }
    } 

void vTasteS2( void ){
    if(pinS2 == 0){                             /* User-Taste gedrückt */
        if(bS2Timer < nTastLong+1){             /* Abfrage max. bis Taste lange gedrückt */
            if(bS2Timer == nTastShort){         /* Taste "kurz gedrückt" erkannt */
#if 1
//...
#endif
                }
            if(bS2Timer == nTastLong){          /* Taste "lange gedrückt" erkannt */ 
                }
            bS2Timer++;
            }
        }
    else{                                       /* Taste nicht gedrückt */ 
        if(bS2Timer >= nTastShort){             /* Taste wurde bereits erkannt */
            }
        bS2Timer = 0;
        }
    } 

void vTasteS3( void ){
    if(pinS3 == 0){                             /* User-Taste gedrückt */
        if(bS3Timer < nTastLong+1){             /* Abfrage max. bis Taste lange gedrückt */
            if(bS3Timer == nTastShort){         /* Taste "kurz gedrückt" erkannt */
#if 1
//...
#endif
                }
            if(bS3Timer == nTastLong){          /* Taste "lange gedrückt" erkannt */ 
                }
            bS3Timer++;
            }
        }
    else{                                       /* Taste nicht gedrückt */ 
        if(bS3Timer >= nTastShort){             /* Taste wurde bereits erkannt */
            }
        bS3Timer = 0;
        }
    } 



void vCheckTasten( void ){
    vTasteS1();
    vTasteS2();
    vTasteS3();
    }

void vDisplayLed( void ){
    switch(bDisplayState){
        case enDoNothing:                           /* Bargraph blinken lassen */
            bBarBlink++;
//...
            break;
        case enDisplay:                             /* Zählwerte für Anzeige ermitteln */
//...
            break;
        }
    wSerial = abZiffer[bIdx&0x0f];
    }

/* Ausschieben der Bits für die Anzeige */
void vShiftLoad(word wLoad){
    word wMask = Bit15;
    pinLoad = 0;
    while(wMask){
        if(wMask & wLoad) pinSdo = 1;
        else              pinSdo = 0;
        pinSck = 1;
        wMask >>= 1;
        pinSck = 0;
        }    
    pinLoad = 1;
    }


/* Ausgabe der Daten an das 7-Segment-Display im Abstand von 2.5 ms */ 
void vSegmentDisplay( void ){
    vShiftLoad(((wSerial << 8) & 0xfff0)| (1 << 3));
    }

/***************************************************************************
*   main()
***************************************************************************/
int main() {
    /* Variablen initialisieren */    
    byte i = 0;
    bIdx = 0;
    bDspTime = 0;
    bDisplayState = enDoNothing;
    stTimer.attach_us(&vSegmentDisplay, 2500);
    bBargraph = 0;
    bBarBlink = 0;
    bDspTimeValue = nDsp100ms;
    iDir = 1;
    /* Lampentest */
    bLedShield = 0x00;
    wait(1);
    bLedShield = 0x0f;
    /* Endless loop */
    while(1) {
        vCheckTasten();
        i++;
        if(i == 10){
            vDisplayLed();
            i = 0;
            }
        wait_us(10000);
        }
    }
