/***************************************************************************
* Titel        : main.c
*
* Description  : Labormodul "HAPO"
*
* Revision List:
  --------------------------------------------------------------------------
  Date     | Author          | Change
  --------------------------------------------------------------------------
  30.10.20 | J. Altenburg    | Ersterstellung
  --------------------------------------------------------------------------
           |                 |
  ----------------------------------------------------------------------------
****************************************************************************/
#include "mbed.h"
#include "cdef.h"

/* Vereinbarungen zu den Tasteneingängen */
DigitalIn   pinS1(A1);
DigitalIn   pinS2(A2);
DigitalIn   pinS3(A3);

/* Ausgänge als "BUS" konfigurieren */
BusOut      bLed(D10, D11, D12, D13);

/***************************************************************************
*   Defines und Makros                                                       *
***************************************************************************/
#define nPressed        0       /* Tasten sind "low active" */
#define nPressedLong    4

#define n500ms          165000  /* Laufzeitparameter für 500 ms */

#define nLed1           0x01    /* Bitposition Led 1 */
#define nLed2           0x02
#define nLed3           0x04
#define nLed4           0x08

#define nLedOff         (nLed1 | nLed2 | nLed3 | nLed4)

enum{                           /* Bezeichner für Zustandsautomat */
      enBlinkNothing = 0
    , enBlinkLed2Only
    , enBlinkAll
    , enBlinkWarnOnly
    };

byte bS3Timer; /*
* Description : Timer für Taste S3
*/

byte bState; /*
* Description : Variable für Zustandsautomat 
*/

dword dwTimer; /*
* Description : Hilfsvariable zur Erzeugung der 200 ms Programmlaufzeit
*/

/* Tastenfunktion Taste S1 */
void vTasteS1( void ){
    byte i;
    i = bLed;                   /* BUS lesen */
    if(pinS1 == nPressed){      /* Taste gedrückt */
        i &= ~nLed1;            /* LED AN */
        }
    else{                       /* Taste nicht gedrückt */
        i |= nLed1;             /* LED AUS */
        }
    bLed = i;
    } 

/* Tastenfunktion Taste S3 */
void vTasteS3( void ){
    }

/* LED2 blinken lassen */
void vToggleLed2( void ){
    }

/* Wechelblinker LED2/3 */
void vToggleLed34( void ){
    }

/* Zustandsautomat */
void vStateMachine( void ){
    }

/***************************************************************************
*   main()
***************************************************************************/
int main() {
    dwTimer = n500ms;
    bLed = nLedOff;
    bState = enBlinkNothing;
    while(1) {                  /* zeitliche Strukur */
        vTasteS1();             /* bei jedem Durchlauf */
        dwTimer--;
        if(dwTimer == 0){       /* alle 500 ms */
            dwTimer = n500ms;
            vTasteS3();
            vStateMachine();
            }
        }
    }
