#if 0

/***************************************************************************
* Titel           : I2C.C
*
* Beschreibung    : IIC - Interface
*
* Kategorie       :
*
* Verantwortlich  : Jens Altenburg
*
* Modulhistory    :
*
 ----------------------------------------------------------------------------
 Date     | Author          | Change
 ----------------------------------------------------------------------------
 28.09.03 | J. Altenburg    | Ersterstellung
 ----------------------------------------------------------------------------

****************************************************************************/

/***************************************************************************
* HEADER-FILES (Only those that are needed in this file)
****************************************************************************/
/* Own headerfiles */
#include "i2c.h"                    /*  */



/***************************************************************************
* FILE LOCAL DEFINITIONS
*
* In this section define
* - all file local macros
* - all file local define-constants
* - all file local ROM-constants (static)
* - all file local type definitions
* - all file local variables (static)
****************************************************************************/
#define nShortDelay             20              /* Verzögerungszeit für I2C */


/***************************************************************************
*   Variablendefinitionen
****************************************************************************/


/***************************************************************************
*   Definition der einzelnen I2C-Befehle
****************************************************************************/
#define _0  0xb0
#define _1  0xb1
#define _2  0xb2
#define _3  0xb3
#define _4  0xb4
#define _5  0xb5
#define _6  0xb6
#define _7  0xb7
#define _8  0xb8
#define _9  0xb9

const byte abInit[]    = {0x74, 0x00, 0x25, 0x06, 0x24, 0x0f, 0x84};
const byte abCls[]     = {0x74, 0x00, 0x84};
const byte abText1[]   = {0x74, 0x40, 0xe3, 0xa7, 0xf4, 0xad, 0xd2, 0xef, 0xe2};
const byte abZeile2[]  = {0x74, 0x00, 0xc4};
const byte abNr0[]     = {0x74, 0x40, 0xd3, 0xf4, 0xe1, 0xf4, 0xe5, 0xa0, _0};
const byte abNr1[]     = {0x74, 0x40, 0xd3, 0xf4, 0xe1, 0xf4, 0xe5, 0xa0, _1};
const byte abNr2[]     = {0x74, 0x40, 0xd3, 0xf4, 0xe1, 0xf4, 0xe5, 0xa0, _2};
const byte abNr3[]     = {0x74, 0x40, 0xd3, 0xf4, 0xe1, 0xf4, 0xe5, 0xa0, _3};
const byte abNr4[]     = {0x74, 0x40, 0xd3, 0xf4, 0xe1, 0xf4, 0xe5, 0xa0, _4};
const byte abNr5[]     = {0x74, 0x40, 0xd3, 0xf4, 0xe1, 0xf4, 0xe5, 0xa0, _5};
const byte abNr6[]     = {0x74, 0x40, 0xd3, 0xf4, 0xe1, 0xf4, 0xe5, 0xa0, _6};
const byte abNr7[]     = {0x74, 0x40, 0xd3, 0xf4, 0xe1, 0xf4, 0xe5, 0xa0, _7};
const byte abNr8[]     = {0x74, 0x40, 0xd3, 0xf4, 0xe1, 0xf4, 0xe5, 0xa0, _8};
const byte abNr9[]     = {0x74, 0x40, 0xd3, 0xf4, 0xe1, 0xf4, 0xe5, 0xa0, _9};
 

/*****************************************************************************
    Name:           vStarti2c()
    Parameters:     none
    Returns:        nothing
    Description:    Generiert das Startsignal für I2C-Bus

******************************************************************************/
void vStarti2c(void){
     vDelay(nShortDelay);
     SDA();                             /* data high */
     vDelay(nShortDelay);
     SCL();                             /* clk high */
     vDelay(nShortDelay);
     _SDA();                            /* data low */
     vDelay(nShortDelay);
     _SCL();                            /* clk low */
     vDelay(nShortDelay);
     }

/*****************************************************************************
    Name:           vStopi2c()
    Parameters:     none
    Returns:        nothing
    Description:    Generiert das Stopsignal für I2C-Bus

******************************************************************************/
void vStopi2c(void){
     vDelay(nShortDelay);
     _SDA();                            /* data low */
     vDelay(nShortDelay);
     SCL();                             /* clk high */
     vDelay(nShortDelay);
     SDA();                             /* data high */
     vDelay(nShortDelay);
     }


/*****************************************************************************
    Name:           vWriteBi2c()
    Parameters:     Byte
    Returns:        nothing
    Description:    Schreibt in Byte auf den I2C-Bus

******************************************************************************/
void vWriteBi2c(byte bData){
     byte i = 0;
     vDelay(nShortDelay);
     _SCL();
     vDelay(nShortDelay);
     for ( i = 0; i < 8; i++){
          if ((bData & 0x80) == 0x80){
               SDA();                   /* Bit := 1 */
               }
          else{
               _SDA();                  /* Bit := 0 */
               }
          bData <<= 1;
          vDelay(nShortDelay);
          SCL();
          vDelay(nShortDelay);
          _SCL();
          vDelay(nShortDelay);
          }
     _SDA();
     vDelay(nShortDelay);
     SCL();
     vDelay(nShortDelay);
     _SCL();
     vDelay(nShortDelay);
     }

/*****************************************************************************
    Name:           vDelay()
    Parameters:     Byte
    Returns:        nothing
    Description:    Laufzeitschleife

******************************************************************************/
void vDelay(byte bTime){
     while(bTime){
          bTime--;
          }
     }

/*****************************************************************************
    Name:           vSendI2C()
    Parameters:     Zeichenanzahl, String
    Returns:        nothing
    Description:    Schickt den String zum I2C Bus

******************************************************************************/
void vSendI2C(byte bLen, byte *pStr){
     word w = 500;
     while(w--);
     vStarti2c();
     while(bLen){
          vWriteBi2c(*pStr);
          pStr++;
          bLen--;
          }
     vStopi2c();
     }

/***************************************************************************
* Kurzbeschreibung     : OV6620 (OV6630) initialisieren
* Uebergabeparameter   : --
* Return Value         : --
* Author               : Jens Altenburg
****************************************************************************/
void I2C_vInit( void ){
     vSendI2C(sizeof(abInit),   (byte *) &abInit[0]);
     vSendI2C(sizeof(abCls),    (byte *) &abCls[0]);
     vSendI2C(sizeof(abText1),  (byte *) &abText1[0]);
     vSendI2C(sizeof(abZeile2), (byte *) &abZeile2[0]);
     vSendI2C(sizeof(abNr0),    (byte *) &abNr0[0]);
     }
     
void I2C_vState(byte bState){
     vSendI2C(sizeof(abZeile2), (byte *) &abZeile2[0]);
     switch(bState){
        case 0:
            vSendI2C(sizeof(abNr0),    (byte *) &abNr0[0]);
            break;
        case 1:
            vSendI2C(sizeof(abNr1),    (byte *) &abNr1[0]);
            break;
        case 2:
            vSendI2C(sizeof(abNr2),    (byte *) &abNr2[0]);
            break;
        case 3:
            vSendI2C(sizeof(abNr3),    (byte *) &abNr3[0]);
            break;
        case 4:
            vSendI2C(sizeof(abNr4),    (byte *) &abNr4[0]);
            break;
        case 5:
            vSendI2C(sizeof(abNr5),    (byte *) &abNr5[0]);
            break;
        case 6:
            vSendI2C(sizeof(abNr6),    (byte *) &abNr6[0]);
            break;
        case 7:
            vSendI2C(sizeof(abNr7),    (byte *) &abNr7[0]);
            break;
        case 8:
            vSendI2C(sizeof(abNr8),    (byte *) &abNr8[0]);
            break;
        case 9:
            vSendI2C(sizeof(abNr9),    (byte *) &abNr9[0]);
            break;
        }
    }            
/***************************************************************************
* EOF: SWMODxC1.C
****************************************************************************/
#endif
