/***************************************************************************
* Titel        : main.c
*
* Description  : Labormodul "DIBI"
*
* Revision List:
  --------------------------------------------------------------------------
  Date     | Author          | Change
  --------------------------------------------------------------------------
  16.11.15 | J. Altenburg    | Ersterstellung
  --------------------------------------------------------------------------
  17.11.17 | J. Altenburg    | Workaround für ISR sperren/freigeben
           |                 |  ab OS5.xx notwendig geworden
  --------------------------------------------------------------------------
  26.11.20 | J. Altenburg    | Grundlage für HomeOffice-Labore
  ----------------------------------------------------------------------------
****************************************************************************/
#include "mbed.h"
//#include "lcd.h"
//#include "image.h"
#include "cdef.h"
#include "lab.h"
#include "sys.h"

/***************************************************************************
*
*   Hardwareinterface
*   - zentrale Vereinbarung von allen Hardwareschnittstellen
*     an dieser Stelle
*   - Zugriff auf Hardwareressourcen aus einem anderen Modul,
*     z.B. lab.cpp NUR über Zugriffsfunktionen (siehe Ansteuerung der LED)
*     
****************************************************************************/
#ifdef nDirectTFT
DigitalOut myled(PB_2);
#else
DigitalOut myled(LED1); /* LED auf Nucleo-Booard */
#endif

BusOut     bLedPCB(PB_2, PA_5, PA_4, PA_13); /*
* Description : vier LEDs auf der Laborplatine
*/

DigitalIn  bButton(PC_13); /*
* Description : Anschluss für User-Button
*/


Serial     stComX(D1,D0);/*
* Description :  UART-Kommunikation (Txd(D1)/Rxd(D0)) USART2 mit dem COM-Port am PC  
*/

Serial     stXBee(PC_10,PC_11);/*
* Description :  XBee-Kommunikation (Txd(PC_10)/Rxd(PC_11), USART3 )  
*/

Serial     stCam4(PA_0,PA_1);/*
* Description :  Camera-Kommunikation (Txd(PA_0)/Rxd(PA_1), UART4)  
*/

Ticker     stTimer; /*
* Description : 5 ms Ticker
*/ 



/***************************************************************************
*   Variablen
****************************************************************************/
byte  bSizeData; /*
* Description : Anzahl der Sendebytes
*/

byte *pUartData; /*
* Description : Zeiger auf diese Daten
*/

byte wXbeeSize; /*
* Description : Anzahl der Sendebyte zum XBee-Modul
*/

byte *pXbeeData; /*
* Description : Zeiger auf diese Daten
*/

byte bCam4Size; /*
* Description : Anzahl der Sendebyte zum Kamera-Modul
*/

byte *pCam4Data; /*
* Description : Zeiger auf diese Daten
*/

volatile byte bTimer; /*
* Description : Zählvariable für 5ms Ticker
*/

byte bTastTimer; /*
* Description : "Tastenzähler"
*/

byte bLedLaborMirror; /*
* Description : Spiegelvariable
*/

byte abString[] = "Hello stComX!\r\n";

/***************************************************************************
*   Defines und Makros                                                       *
***************************************************************************/
#define nTastShort    4     /* Taste 50 Millisekunden gedrückt */    
#define nTastLong   150     /* Taste 1.5 Sekunden gedrückt */    



/***************************************************************************
*   lokale Funktionsprototypen
***************************************************************************/
void vTaste( void );

/***************************************************************************
*   lokale Funktionen
***************************************************************************/
/*  Ansteuerung der LED auf dem Nucleo-Bord */
void SYS_vLed( byte bLed ){
    if      (bLed == 0) myled = 0;
    else if (bLed == 1) myled = 1;
    else                myled = !myled;
    }

/* Leds auf der Laborplatine einstellen */
void SYS_vSetLed( byte bLed, byte bLogik ){
    switch(bLogik){
        default:
            break;
        case nON:
            bLedLaborMirror |= bLed;
            bLedPCB = ~bLedLaborMirror;
            break;
        case nOFF:
            bLedLaborMirror &= ~bLed;
            bLedPCB = ~bLedLaborMirror;
            break;
        case nXOR:
            bLedLaborMirror ^= bLed;
            bLedPCB = ~bLedLaborMirror;
            break;
        }
    }


/* 10 ms Container */
void vTicker( void ){
    vTaste();
    LAB_v10ms();
    }

/*  COM-Port - Transfer starten
    - Start einer Übertragung zum COM-Port per ISR 
    - die Quelle und die Anzahl der Zeichen wird an globale
      Variablen übergeben
    - die ISR nutzt diese Variablen 
    - das erste Zeichen wird in das Senderregister geschrieben,
      damit startet die ISR vIsrTxComX(); 
    - wenn das letzte Zeichen gesendet ist, stoppt die ISR
*/
byte SYS_vStartComX( byte *pData, byte bSize ){     /* Start einer Übertragung zum COM-Port per ISR */
    byte i;
    if(bSizeData) i = False; 
    else{
        bSizeData = bSize;                      /* Anzahl der Sendedaten (max. 256 Byte) */
        pUartData = pData;                      /* Zeiger auf diese Daten */
        stComX.putc(*pUartData);                /* erstes Zeichen senden */
        pUartData++;
        bSizeData--;
        USART2->CR1 |= USART_CR1_TXEIE;         /* TXE-Interrupt freigeben */
        i = True;
        }
    return i;
    }

/* Senderoutine zum COM-Port am PC */
void vIsrTxComX( void ){                        /* Senderoutine */
    if(stComX.writeable()){                     /* Sende-ISR */
        if(bSizeData){                          /* sind Daten vorhanden ? */
            stComX.putc(*pUartData);            /* daten senden */
            pUartData++;
            bSizeData--;
            }
        else{
            USART2->CR1 &= ~USART_CR1_TXEIE;    /* Interrupt sperren */
            }
        }
    }
    
/* Empfangsroutine vom COM-Port des PC */
void vIsrRxComX( void ){                        /* Empfangsroutine */
    if(stComX.readable()){                      /* Empfangs-ISR */
        LAB_vRxFromPC(stComX.getc());
        }
    }

/* XBee - Transfer starten 
   - die Funktion der seriellen Kanäle ist ähnlich, siehe SYS_vStartComX(..);
*/
byte SYS_vStartXBee( byte *pData, word wSize ){
    byte i;
    if(wXbeeSize) i = False;
    else{
        wXbeeSize = wSize;                      /* Anzahl der Sendedaten */
        pXbeeData = pData;                      /* Zeiger auf diese Daten */
        stXBee.putc(*pXbeeData);                /* erstes Zeichen senden */
        pXbeeData++;
        wXbeeSize--;
        USART3->CR1 |= USART_CR1_TXEIE;         /* TXE interrupt freigeben */
        i = true;
        }
    return i;
    }

/* Senderoutine zum XBee-Modul auf dem Board */
void vIsrTxXBee( void ){                        /* Senderoutine */
    if(stXBee.writeable()){                     /* Sende-ISR */
        if(wXbeeSize){                          /* sind noch Daten vorhanden ? */
            stXBee.putc(*pXbeeData);            /* weiter seden */
            pXbeeData++;
            wXbeeSize--;
            }
        else{
            USART3->CR1 &= ~USART_CR1_TXEIE;    /* erledigt */
            }
        }
    }
    
/* Empfangsroutine des XBee-Modules */
void vIsrRxXBee( void ){                        /* Empfangsroutine */
    if(stXBee.readable()){                      /* Empfangs-ISR */
        LAB_vRxFromXbee(stXBee.getc());
        }
    }

/* Empfangsroutine vom Cam4-Port des Kameramodules 
   - die Funktion der seriellen Kanäle ist ähnlich, siehe SYS_vStartComX(..);
*/
byte SYS_vStartCam4( byte *pData, byte bSize ){
    byte i;
    if(bCam4Size) i = False;
    else{
        bCam4Size = bSize;                      /* Anzahl der Sendedaten */
        pCam4Data = pData;                      /* Zeiger auf diese Daten */
        stCam4.putc(*pCam4Data);                /* erstes Zeichen senden */
        pCam4Data++;
        bCam4Size--;
        UART4->CR1 |= USART_CR1_TXEIE;         /* TXE interrupt freigeben */
        i = True;
        }
    return i;
    }


/* Empfangsroutine vom Cam4-Port des Kameramodules */
void vIsrRxCam4( void ){                        /* Empfangsroutine */
    if(stCam4.readable()){                      /* Empfangs-ISR */
        //stComX.putc(stCam4.getc());
        LAB_vRxFromCam4(stCam4.getc());
        }
    }

/* Senderoutine zum XBee-Modul auf dem Board */
void vIsrTxCam4( void ){                        /* Senderoutine */
    if(stCam4.writeable()){                     /* Sende-ISR */
        if(bCam4Size){                          /* sind noch Daten vorhanden ? */
            stCam4.putc(*pCam4Data);            /* weiter senden */
            pCam4Data++;
            bCam4Size--;
            }
        else{
            UART4->CR1 &= ~USART_CR1_TXEIE;    /* erledigt */
            }
        }
    }


/* Tastenabfrage */
void vTaste( void ){
    if(bButton == 0){                           /* User-Taste gedrückt */
        if(bTastTimer < nTastLong+1){           /* Abfrage max. bis Taste lange gedrückt */
            if(bTastTimer == nTastShort){       /* Taste "kurz gedrückt" erkannt */
                LAB_vTasteShort();              /* Event dazu */
                }
            if(bTastTimer == nTastLong){        /* Taste "lange gedrückt" erkannt */ 
                LAB_vTasteLong();
                }
            bTastTimer++;
            }
        }
    else{                                       /* Taste nicht gedrückt */ 
        if(bTastTimer >= nTastShort){           /* Taste wurde bereits erkannt */
            LAB_vTasteFree();                   /* Event "Losgelassen" */
            }
        bTastTimer = 0;
        }
    } 

/***************************************************************************
*   main()
***************************************************************************/
int main() {
    byte i;
    wait(0.5);                                  /* gelegentlich hängt die SPI - Grund noch unklar @JA 16.11.15 */
    bTastTimer = 0;
/*
 *  10ms Container
 */
    stTimer.attach_us(&vTicker, 10000);         /* 10ms Ticker */
/*
 *  Kommunikation mit dem COM-Port des PCs
 */
    stComX.attach(&vIsrRxComX, Serial::RxIrq);  /* Kommunikation zum PC */
    stComX.attach(&vIsrTxComX, Serial::TxIrq);
/*
 *  Kommunikation mit dem XBee-Modul
 */
    stXBee.attach(&vIsrRxXBee, Serial::RxIrq);  /* Kommunikation zum XBee-Modul */
    stXBee.attach(&vIsrTxXBee, Serial::TxIrq);

/*
 *  Kommunikation mit dem Kamera-Modul
 */
    stCam4.baud(19200);
    stCam4.attach(&vIsrRxCam4, Serial::RxIrq);  /* Kommunikation mit dem Kamera-Modul */
    stCam4.attach(&vIsrTxCam4, Serial::TxIrq);

#if 0   /* Test der drei seriellen Schnittstellen */
    i = 5;
    while(i--){ 
        SYS_vLed(2);
        wait(0.5);
        SYS_vStartComX(&abString[0], sizeof(abString));
        SYS_vStartXBee(&abString[0], sizeof(abString));
        SYS_vStartCam4(&abString[0], sizeof(abString));
        }
#endif  

/*
 *  Labor starten 
 */
    LAB_vInit();                                /* Laborwerte initialisieren */
    LAB_vMain();                                /* Labor aufrufen und niemal zurückkehren */
    }

