#ifndef LCD_H
#define LCD_H

#include "platform.h"
#include "wait_api.h"
#include "gpio_api.h"
#include "spi_api.h"
#include "cdef.h"

#define MIN_X   0
#define MIN_Y   0
#define MAX_X   239
#define MAX_Y   319

//Basic Colors
#define RED     0xf800
#define GREEN   0x07e0
#define BLUE    0x001f
#define BLACK   0x0000
#define YELLOW  0xffe0
#define WHITE   0xffff

//Other Colors
#define CYAN        0x07ff  
#define BRIGHT_RED  0xf810  
#define GRAY1       0x8410  
#define GRAY2       0x4208

#define FONT_SPACE 6
#define FONT_X 8
#define FONT_Y 8

#ifdef __cplusplus
extern "C" {
#endif

extern uint8_t simpleFont[][8];

typedef enum
{
    PORTRAIT = 0,
    LANDSCAPE = 1
 } lcd_mode;

typedef struct
{
  lcd_mode mode;
  spi_t * spi;
  gpio_t CS;
  gpio_t CD;
} lcd_t;

#define LCD_vInit   lcd_init
/*********************************************
 * Display wird initialisiert 
 * Aufruf LCD_vInit(
 *              lcd_t *     - Übergabestruktur
 *
 * Beispiel: LCD_vInit(&myLCD, &mySPI, p22, p23);
 *********************************************/

#define LCD_vDrawFloat lcd_drawFloat
/*********************************************
 * gibt eine Floating-Point-Zahl zum Display
 * Aufruf LCD_vDrawFloat(
 *              lcd_t *     - Übergabestruktur
 *
 *********************************************/

#define LCD_vDrawRectangle lcd_drawRectangle
/*********************************************
 * zeichnet ein leeres Rechteck
 * Aufruf LCD_vDrawRectangle(
 *              lcd_t *     - Übergabestruktur
 *
 * Beispiel: LCD_vDrawRectangle(&myLCD, 20, 20, 50, 50, BLACK);
 *********************************************/

#define LCD_vFillRectangle lcd_fillRectangle
/*********************************************
 * zeichnet ein gefülltes Rechteck
 * Aufruf LCD_vFillRectangle(
 *              lcd_t *     - Übergabestruktur
 *
 * Beispiel: LCD_vFillRectangle(&myLCD, 10, 10, 50, 50, BLUE);
 *********************************************/

#define LCD_vFillSprite lcd_fillSprite
/*********************************************
 * gibt eine Grafik aus 
 * funktioniert nur im Mode LANDSCAPE
 * Aufruf LCD_vFillSprite(
 *              lcd_t *     - Übergabestruktur
 *
 * Beispiel: LCD_vFillSprite(&myLCD, 200, dwPos, 69, 86, (int*) &awRobot[0]);
 *********************************************/

#define LCD_vSetMode lcd_setMode
/*********************************************
 * Hoch- (PORTRAIT) oder Querformat (LANDSCAPE)
 * Aufruf LCD_vSetMode(
 *              lcd_t *     - Übergabestruktur
 *
 * Beispiel: LCD_vSetMode(&myLCD, LANDSCAPE);
 *********************************************/

//#define LCD_vDrawLine vDontCheat
#define LCD_vDrawLine lcd_drawLine
/*********************************************
 * zeichnet eine Linie
 * Aufruf LCD_vDrawLine(
 *              lcd_t *     - Übergabestruktur
 *
 * Beispiel: LCD_vDrawLine(&myLCD, 30, 30, 70, 90, RED);
 *********************************************/

#define LCD_vDrawTraingle lcd_drawTraingle
/*********************************************
 * zeichnet ein Dreieck
 * Aufruf LCD_vDrawTraingle(
 *              lcd_t *     - Übergabestruktur
 *
 * Beispiel: LCD_vDrawTraingle(&myLCD, 0, 200, 30, 220, 15, 240, BRIGHT_RED);
 *********************************************/

#define LCD_vFillTraingle lcd_fillTraingle
/*********************************************
 * zeichnet ein gefülltes Dreieck
 * Aufruf LCD_vFillTraingle(
 *              lcd_t *     - Übergabestruktur
 *
 * Beispiel: LCD_vFillTraingle(&myLCD, 10, 100, 40, 120, 25, 150, GRAY1);
 *********************************************/

#define LCD_vDrawCircle lcd_drawCircle
/*********************************************
 * zeichnet ein gefülltes Dreieck
 * Aufruf LCD_vDrawCircle(
 *              lcd_t *     - Übergabestruktur
 *
 * Beispiel: LCD_vDrawCircle(&myLCD, 160, 120, 50, BLACK);
 *********************************************/


#define LCD_vSetRotation lcd_vSetRotation
/*********************************************
 * Syntax-Korrektur
 *********************************************/
 
#define LCD_vDrawString lcd_drawString
/*********************************************
 * Syntax-Korrektur
 *********************************************/
 
 #define LCD_vSetPixel lcd_setPixel
/*********************************************
 * zeichnet einen Punkt
 * Aufruf LCD_vSetPixel(
 *              lcd_t *     - Übergabestruktur
 *
 * Beispiel: LCD_vSetPixel(&myLCD, 160, 120, BLACK);
 *********************************************/

#define LCD_vDrawVline lcd_drawHorizontalLine
//(lcd_t * lcd, int x, int y, int length, int color);

#define LCD_vDrawHline lcd_drawVerticalLine
//(lcd_t * lcd, int x, int y, int length, int color);


void lcd_init(lcd_t * lcd, spi_t * spi, PinName CS, PinName CD);

void lcd_cs(lcd_t * lcd, int value);

void lcd_cd(lcd_t * lcd, int value);

void lcd_setMode(lcd_t * lcd, lcd_mode mode);

void lcd_writeCommand(lcd_t * lcd, int value);

void lcd_writeData(lcd_t * lcd, int value);

void lcd_writeData16(lcd_t * lcd, int value);

void lcd_setColumn(lcd_t * lcd, int start, int end);

void lcd_setPage(lcd_t * lcd, int start, int end);

void lcd_fillScreen(lcd_t * lcd);

void lcd_drawLine(lcd_t * lcd, int x0, int y0, int x1, int y1, int color);

void lcd_drawVerticalLine(lcd_t * lcd, int x, int y, int length, int color); // Fertig jedoch ggf noch ändern

void lcd_drawHorizontalLine(lcd_t * lcd, int x, int y, int length, int color); // fertig jedoch ggf noch ändern

void lcd_drawRectangle(lcd_t * lcd, int x0, int y0, int x1, int y1, int color);

void lcd_fillRectangle(lcd_t * lcd, int x0, int y0, int x1, int y1, int color);

void lcd_fillSprite(lcd_t * lcd, int x0, int y0, int length, int width, short int *color);

void lcd_drawTraingle(lcd_t *lcd, int x0, int y0, int x1, int y1, int x2, int y2, int color);

void lcd_fillTraingle(lcd_t *lcd, int x0, int y0, int x1, int y1, int x2, int y2, int color);

void lcd_setLandscape(lcd_t * lcd);

void lcd_setPortrait(lcd_t * lcd);

void lcd_setXY(lcd_t * lcd, int x, int y);

void lcd_setPixel(lcd_t * lcd, int x, int y, int color);

void lcd_drawCircle(lcd_t * lcd, int x, int y, int radius, int color);

void lcd_drawChar(lcd_t * lcd, char c, int x, int y, uint16_t size, uint16_t color); // Fertig

void lcd_drawString(lcd_t * lcd, char * ca, int x, int y, uint16_t size, uint16_t color); // Fertig

uint8_t lcd_drawNumber(lcd_t * lcd, long long_num, int x, int y, uint16_t size, uint16_t color); // Fertig

uint8_t lcd_drawFloat(lcd_t * lcd, float floatNumber, uint8_t decimal, int x, int y, uint16_t size, uint16_t color); // Fertig

void lcd_vSetRotation(byte bRot);


void lcd_testTrawLine(lcd_t * lcd, int x0, int y0,int x1, int y1,int color);

#ifdef __cplusplus
}
#endif

#endif

