/***************************************************************************
* Titel        : LAB.C
*
* Description  : Labormodul "DIBI"
*
* Revision List:
  --------------------------------------------------------------------------
  Date     | Author          | Change
  --------------------------------------------------------------------------
  15.11.13 | J. Altenburg    | Ersterstellung
  --------------------------------------------------------------------------
           |                 |
  --------------------------------------------------------------------------
****************************************************************************/

/***************************************************************************
* HEADER-FILES (Only those that are needed in this file)
****************************************************************************/
/* Own header */
#include "lab.h"

/* Foreign headerfiles */
#include "lcd.h"
#include "mbed.h"
#include "sys.h"
#include "picture.h"


/***************************************************************************
*   Variablen für das Template
*   in diesem Bereich bitte keine Variablen durch die Versuchsteilnehmer
*   plazieren
****************************************************************************/
lcd_t myLCD; /* 
* Description : benoetigte Strukturen fuer LCD 

*/ 
spi_t mySPI; /* 
* Description : und SPI 
*/

byte bLabState; /*
* Description : Zustrandsautomat für LAB_vMain
*/

#if 0
byte abSmile[] = "Station-ID"; /*
* Description : Nicht schummeln Liebling!
*/
#endif

byte abPicture[160][120] = {20};  /*
* Description : Bildspeicher fuer Grauwertbild 
*/

word awHistogramm[64] = {20}; /*
* Description : Histogrammvektor
*/

/***************************************************************************
*   lokale Funktionsprototypen
***************************************************************************/


/***************************************************************************
*   Defines und Makros                                                       *
***************************************************************************/
//#define LABOR1
#define LABOR2
//#define LABOR3

#define n100ms  10
#define n300ms  30
#define n500ms  50

/***************************************************************************
*   Ab hier bitte die Werte durch die Versuchsteilnehmer plazieren
****************************************************************************/
enum{                   /* Zustände der LAB_vMain() */
      enInit = 0
    , enDrawPosition    /* Anzeige der modifizierten X/Y-Positionswerte */
    , enDrawLine        /* Linie zeichnen */
    , enDrawCircle      /* Kreis zeichnen*/
    , enDrawRobot       /* Roboter zeichnen */
    , enPicture         /* Lab2 - Picture in Sekror 1 anzeigen */
    , enBlackWhite      /* Lab2 - Schwarz-Weiss-Bild berechnen und anzeigen */
    , enHistogramm      /* Lab2 - Histogramm zeichnen */
    , enIncPixel        /* Lab2 - Pixelwerte erhöhen */
    , enDecPixel        /* Lab2 - Pixelwerte verringern */
    };

#if 0
enum{
    enDoNothing = 0,
    enRefresh,
    enCalculate,
    enNewStation
    };
#endif

//const byte abLaborText[]  = "Willkommen zum Laborversuch! \n\r";
const byte abLaborText2[] = "Willkommen zum Labor-Nr. 2 ! \n\r";
 
byte bRobotPosX = 0; /*
* Desciption : X-Position des Roboters
*/

byte bRobotPosY = 0; /*
* Description : Y-Position des Roboters
*/

byte abRobotPosXText[] = "  0"; /*
* Description : Teststrng zur Anzeige der X-Position
*/
byte abRobotPosYText[] = "  0"; /*
* Description : siehe oben
*/

byte abLineRangeError[] = "Die Angabe der x- oder y-Parameter liegt nicht im vorgegebenen Bereich"; /*
* Description : Error Text falls die Angabe für x oder y außerhalb des möglichen Bereichs liegt
*/

byte bCountL = 0;/*
* Description : Zählt wie oft die Taste L gedrückt wurde
*/

byte bRadius = 10;/*
* Description : Bestimmt den radius des Kreises
*/

/***************************************************************************
*   lokale Funktionen
*   Vorgabe durch Prof. Altenburg
****************************************************************************/
/* Umrechnen eines Farbwertes in einen Grauwert */
byte bRGB565ToGray(word wColor){
    word wRed, wGreen, wBlue, wLumi;
    wBlue  = wColor & 0x1f;
    wBlue  = wBlue << 1;                /* jetzt 64 Stufen */
    wGreen = (wColor >> 5)  & 0x3f;
    wRed   = (wColor >> 11) & 0x1f; 
    wRed   = wRed << 1;
    wLumi  = (29*wRed + 58*wGreen + 11*wBlue)/100;
    if(wLumi > 63) wLumi = 63;
    return (byte)wLumi;
    }



/* Umrechnen des Farbbildes in ein Grauwertbild */
void vColorToGray(word *pColor, byte *pGray){
    word w;
    for(w = 0; w < 19200; w++){
        *pGray = bRGB565ToGray(*pColor);
        pGray++;
        pColor++;
        }
    }

/* Grauwertbild in Sektor 2 plazieren */
void vGrayToScreen2(byte *pGray){
    word wColor, w, v;
    byte x, y;
    x = y = 0;
    for(v = 0; v < 19200; v++){
        wColor = *pGray >> 1;   /* Blau */
        w = *pGray;
        w <<= 5;
        wColor |= w;            /* Grüen */
        w = *pGray >> 1;
        w <<= 11;
        wColor |= w;             /* Rot */
        pGray++;
        lcd_setPixel(&myLCD, 120 + y, 160 + x, wColor);
        y++;
        if(y > 119){
            y = 0;
            x++;
            }
        }
    }

/* Grauwertbild in Sektor 3 plazieren */
void vGrayToScreen3(byte *pGray){
    word wColor, w, v;
    byte x, y;
    x = y = 0;
    for(v = 0; v < 19200; v++){
        wColor = *pGray >> 1;   /* Blau */
        w = *pGray;
        w <<= 5;
        wColor |= w;            /* Grüen */
        w = *pGray >> 1;
        w <<= 11;
        wColor |= w;             /* Rot */
        pGray++;
        lcd_setPixel(&myLCD, y, 160 + x, wColor);
        y++;
        if(y > 119){
            y = 0;
            x++;
            }
        }
    }

/* Variable in Text umrechnen */
void vByteToPosText(byte bValue, byte *pString){
    byte i;
    if(bValue >= 100){               /* hunderter behandeln */
        i = bValue/100;
        *pString = '0'+i;
        bValue = bValue - (i*100);
        }
    else *pString = ' ';
    pString++;
    if(bValue >= 10){
        i = bValue/10;
        *pString = '0'+i;
        bValue = bValue - (i*10);
        }
    else *pString = ' ';
    pString++;
    *pString = '0'+bValue;
    }


#ifdef LABOR2 /* Laborversuch 2*/
/* Berechnen des Histogrammvektors
 * in der X-Position der Variableen awHistogramm[x] ist die Anzahl der Pixel 
 * mit dem Helligkeitswert kodiert
 * Beispiel: 
   - ist awHistogramm[0] = 0, so gibt es keinen  Bildpunkt mit dem Helligkeitswert 0
   - ist awHistogramm[63] = 19200, dann haben ALLE Bildpunkt des Graywertbildes den Wert 63 ==> Weiss
 * zur Histogrammberechnung muss also nur für alle Bildpunkte der Index in awHistogramm erhöhrt werden
 * der Index ist der Pixelwert des Bildpunktes 
 */
void vCalculateHistogramm( void ){
    word wPixelNumber;
    byte i, *pPixel;
    pPixel = &abPicture[0][0];              /* zeiger auf das Graywertbild */
    for(i = 0; i < 64; i++){
        awHistogramm[i] = 0;                /* Histogramm löschen */
        }
    for(wPixelNumber = 0; wPixelNumber < 19200; wPixelNumber++){
        // Laboraufgabe 5   /* Pixelwert als Index interpretieren */
        /* ..... Programm hier ergänzen */
        pPixel++;                           /* nächster Pixel (Bildpunkt) */
        }
    }

/* Histogramm in Sektor 2 zeichnen */
void vDrawHistogramm(byte *pGray){
    word y, wMax = 0;
    byte i, j, n;
    LCD_vFillRectangle(&myLCD, 160, 0, 159, 119, GRAY1);    /* grauer Hintergrund */
    for(i = 0; i < 64; i++){
        if(awHistogramm[i] > wMax) wMax = awHistogramm[i];  /* Maximalwert ermitteln */
        }
    wMax = wMax / 100;                                      /* Wert normieren */
    for(i = 0; i < 64; i++){                                /* die 64 möglichen Werte darstellen */
        n = i * 2;
        y = awHistogramm[i] / wMax;
        if(y > 63) y = 63;
        //y = i;
        for(j = 0; j < y; j++){
            LCD_vSetPixel(&myLCD, 139+j, 169+n, BRIGHT_RED);
            LCD_vSetPixel(&myLCD, 139+j, 170+n, BRIGHT_RED);
            }
        }
    for(i = 0; i < 128; i = i + 16){
        LCD_vDrawVline(&myLCD, 180+i, 20, 84, GRAY2);
        }
    for(i = 0; i < 128; i++){
        LCD_vSetPixel(&myLCD, 203, 169+i, BLUE);
        }
    }
#endif


/***************************************************************************
*    Initialisierung
****************************************************************************/
void LAB_vInit( void ){
/* 
 *   SPI - MOSI, MISO, SCLK festlegen der tatsächlichen Signalleitungen 
 */
 #ifdef nDirectTFT
    spi_init(&mySPI, PA_7, PA_6, PA_5, NC); 
 #else
    spi_init(&mySPI, PB_15, PB_14, PB_13, NC);  /* Leitungen fuer Arduino-Extension */ 
 #endif
    spi_format(&mySPI, 8, 0, 0);                /* 8-Bit Uebertragung */
    spi_frequency(&mySPI, 20000000);            /* 20 MHz Taktgeschwindigkeit */
/* 
 *  LCD 
 */   
#ifdef nDirectTFT
    LCD_vInit(&myLCD, &mySPI, D5, D6);          /* p22, p23 */
#else
    LCD_vInit(&myLCD, &mySPI, PA_15, PA_14);    /* TFT programmieren */
#endif
    LCD_vSetMode(&myLCD, LANDSCAPE);            /* Querformat */


/* -----------------------------------
 * Start Programmbereich für Studenten 
 * ----------------------------------- */

/*
 * Erzeugen des Startbildschirmes fuer LABOR1 
 */ 
#ifdef LABOR1 /* Laborversuch 1*/
    /* Menueeinträge mit Bedientasten [L], [K], ... */
    LCD_vDrawString(&myLCD,(char*)"Grundmenue Labor 1",30,120,2,BLUE);  
    LCD_vDrawString(&myLCD,(char*)"Zeichne Linie      [L]",30,145,1,BLACK);
    LCD_vDrawString(&myLCD,(char*)"Zeichne Kreis [l/s][K]",30,160,1,BLACK);
    LCD_vDrawString(&myLCD,(char*)"Setze X-Position [x/X]",30,175,1,BLACK);
    LCD_vDrawString(&myLCD,(char*)"Setze Y-Position [y/Y]",30,190,1,BLACK);
    LCD_vDrawString(&myLCD,(char*)"Zeichne Robot      [R]",30,205,1,BLACK);
    /* Zustandsautomat Lab_vMain() initialisieren */
    bLabState = enDrawPosition;
    /* Teststring zur seriellen Schnittstelle */
    SYS_vStartComX((byte*)&abLaborText[0], sizeof(abLaborText));
    //LCD_vDrawLine(&myLCD, 30, 30, 70, 90, RED);
    //LCD_vFillSprite(&myLCD, bRobotPosX, bRobotPosY, 69, 86, (short*) &awRobo[0]);
    //LCD_vDrawCircle(&myLCD, 50, 50, 10, GREEN);
#endif

#ifdef LABOR2 /* Laborversuch 2*/
    LCD_vDrawString(&myLCD,(char*)"Grundmenue Labor 2",30,120,2,BLUE);  
    bLabState = enInit;
    SYS_vStartComX((byte*)&abLaborText2[0], sizeof(abLaborText2));
    LCD_vDrawString(&myLCD,(char*)"Zeichne Picture      [P]",30,145,1,BLACK);
    LCD_vDrawString(&myLCD,(char*)"Berechne SW-Bild     [B]",30,160,1,BLACK);
    LCD_vDrawString(&myLCD,(char*)"Zeichne Histogramm   [H]",30,175,1,BLACK);
    LCD_vDrawString(&myLCD,(char*)"Incremetiere Pixel   [+]",30,190,1,BLACK);
    LCD_vDrawString(&myLCD,(char*)"Decremetiere Pixel   [-]",30,205,1,BLACK);
#endif

#ifdef LABOR3 /* Laborversuch 1*/
    LCD_vDrawString(&myLCD,(char*)"Grundmenue Labor 3",30,120,2,BLUE);  
    bLabState = enInit;
    SYS_vStartComX((byte*)&abLaborText[0], sizeof(abLaborText));
#endif
    }

/***************************************************************************
*    Labor-Main
*    - diese Funktion wird nicht wieder verlassen
*    - endless loop für Anwenderprogramm
****************************************************************************/
void LAB_vMain( void ){
    byte *pPixel;
    while(1) {
        switch(bLabState){
            case enInit:
                break;
            case enDrawPosition:
                bLabState = enInit;
                break;
            case enDrawLine:            /* Zeichnet eine Linie von Punk P1[x0,y0] nach P2[x1,y1] */
                bLabState = enInit;
                break;
            case enDrawCircle:          /* Zeichnet einen Kreis */
                bLabState = enInit;
                break;
            case enDrawRobot:           /* Zeichnet die "Robotergrafik" an der Position (bRobotPosX, bRobotPosY) */
                bLabState = enInit;
                break;
#ifdef LABOR2
            /* Laboraufgabe 1. */
            case enPicture:
                LCD_vFillSprite(&myLCD, 0, 0, 159, 119,(short int*)&awBlume[0]);
                bLabState = enInit;
                break;
            /* Laboraufgabe 2. */
            case enBlackWhite:
                /* Umrechnung RGB565 - Graystufen */
                /* SW-Bild in Sektor 2 plazieren */
                bLabState = enInit;
                break;
            /* Laboraufgabe 5. */
            case enHistogramm:
                vCalculateHistogramm();                                 /* Lab2 - Histogramm berechnen */
                vDrawHistogramm(&abPicture[0][0]);                      /* Lab2 - Histogramm ausgeben */
                bLabState = enInit;
                break;
            /* Laboraufgabe 6. */
            case enIncPixel:                                            /* Lab2 - Pixelwerte erhöhen */
                pPixel = &abPicture[0][0];
                /* .....................
                
                
                */
                vGrayToScreen2(&abPicture[0][0]);
                bLabState = enInit;
                break;
            /* Laboraufgabe 6. */    
            case enDecPixel:                                            /* Lab2 - Pixelwerte verringern */
                pPixel = &abPicture[0][0];
                /* ........................
                
                
                
                 */
                vGrayToScreen2(&abPicture[0][0]);
                bLabState = enInit;
                break;
#endif
            }
        }
    }



/***************************************************************************
*    10 - Millisekunden-Container
*    - diese Funktion wird alle 10 ms aufgerufen
*    - ist als ISR angelegt, d.h. unterbricht die LAB_vMain()
****************************************************************************/
void LAB_v10ms( void ){
    }


/***************************************************************************
*    ISR zum Zeichenempfang vom PC
*    - Aufruf beim Empfang eines Zeichens vom COM-Port des PCs
*    - zum Zeichen senden muss ein Terminal am PC geöffnet sein
*    - die Zeichen kommen einzeln, d.h. Funktionsaufruf bei jedem Zeichen
*    - das gesendete Zeichen ist in bData enthalten
****************************************************************************/
void LAB_vRxFromPC( byte bData ){
    switch(bData){
#ifdef LABOR2
        case 'p':
        case 'P':
            /* Laboraufgabe 1 */
            break;
        case 'b':
        case 'B':
            /* Laboraufgabe 2*/
            break;
        case 'h':
        case 'H':
            bLabState = enHistogramm;
            break;
        case '+':
            /* Laboraufgabe 6 */
            break;
        case '-':
            /* Laboraufgabe 6 */
            break;
#endif 
        }
    }

/***************************************************************************
*    ISR zum Zeichenempfang vom XBee-Modul
*    - Funktion wie beim COM-Port
*    - Zeichen kommt vom Funkmodul
****************************************************************************/
void LAB_vRxFromXbee( byte bData ){
    }


/***************************************************************************
*    ISR zum Zeichenempfang vom Kamera-Modul
*    - Funktion wie beim COM-Port
*    - Zeichen kommt von der Kamera
****************************************************************************/
void LAB_vRxFromCam4( byte bData ){
    }

/***************************************************************************
*    Tastenfunktionen
*    - Funktion wird beim kurzen Tastendruck aufgerufen
****************************************************************************/
void LAB_vTasteShort( void ){
    }

/***************************************************************************
*    Tastenfunktionen
*    - Funktion wird beim langen Tastendruck aufgerufen
****************************************************************************/
void LAB_vTasteLong ( void ){
    }

/***************************************************************************
*    Tastenfunktionen
*    - Funktion wird beim Loslassen der Taste aufgerufen
****************************************************************************/
void LAB_vTasteFree ( void ){
    }



/***************************************************************************
* EOF: TEMPLATE.C
****************************************************************************/

