#include "mbed.h"
#include "DebouncedIn.h"
#include "TextLCD.h"

AnalogIn Vin(PTC2);
AnalogOut Vout(PTE30);
TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7


DebouncedIn button1(PTC12);
DebouncedIn button2(PTC13);
DebouncedIn button3(PTC16);
DebouncedIn button4(PTC17);

int C1=0x0F;
int C4=0x0C; // quito cursor bajo
int sp=0,kp=0,kd=0,ki=0,p=1;
int med,err,pid,ap,ai=0,ai1,ad,err_v;
int i;
int fe;
float pidn;


int main()
{
    lcd.cls();
    lcd.writeCommand(C1);//escribimos un comando segun el manual del modulo LCD
    lcd.locate(8,0);
    lcd.printf("Fe=%d", fe);
    lcd.locate(0,1);
    lcd.printf("P=%d", kp);
    lcd.locate(6,1);
    lcd.printf("I=%d", ki);
    lcd.locate(11,1);
    lcd.printf("D=%d", kd);
    lcd.locate(0,0);
    lcd.printf("Sp=%d", sp);

    while(1)
    {
        if (button1.falling())
        {
            
            if (p==1)
            {
                ++sp;
                lcd.locate(3,0);
                lcd.printf("   ");
                lcd.locate(3,0);
                lcd.printf("%d", sp);
            }
            else if (p==2)
            {
                ++i;
                if (i==1){
                 fe =1;}
                if (i==2){
                 fe =10;}
                if (i==3){
                 fe =100;
                 i=0;} 
                
                lcd.locate(11,0);
                lcd.printf("   ");
                lcd.locate(12,0);
                lcd.printf("   "); 
                lcd.locate(13,0);
                lcd.printf("   ");
               
                 
                lcd.locate(11,0);
                lcd.printf("%d", fe);
            }
            else if (p==3)
            {
                ++kp;
                lcd.locate(2,1);
                lcd.printf("   ");
                lcd.locate(2,1);
                lcd.printf("%d", kp);
            }
            else if (p==4)
            {
                ++ki;
                lcd.locate(8,1);
                lcd.printf("   ");
                lcd.locate(8,1);
                lcd.printf("%d", ki);
            }
             else if (p==5)
            {
                ++kd;
                lcd.locate(13,1);
                lcd.printf("   ");
                lcd.locate(13,1);
                lcd.printf("%d", kd);
            }
        }
        if (button2.falling())
        {
            
            if (p==1)
            {
                if (sp==0)  // no mostrar nada
                {
                }
                else
                {
                    --sp;
                    lcd.locate(3,0);
                    lcd.printf("   ");
                    lcd.locate(3,0);
                    lcd.printf("%d", sp);
                }
            }
         
            if (p==3)
            {
                if (kp==0)  // no mostrar nada
                {
                }
                else
                {
                    --kp;
                    lcd.locate(2,1);
                    lcd.printf("   ");
                    lcd.locate(2,1);
                    lcd.printf("%d", kp);
                }
            }
            if (p==4)
            {
                if (ki==0)  // no mostrar nada
                {
                }
                else
                {
                    --ki;
                    lcd.locate(8,1);
                    lcd.printf("   ");
                    lcd.locate(8,1);
                    lcd.printf("%d", ki);
                }
            }
             if (p==5)
            {
                if (kd==0)  // no mostrar nada
                {
                }
                else
                {
                    --kd;
                    lcd.locate(13,1);
                    lcd.printf("   ");
                    lcd.locate(13,1);
                    lcd.printf("%d", kd);
                }
            }
        }
   
      if (button3.falling())
        {         
            if (p==1)
            {
                ++p;
                lcd.locate(11,0);
                lcd.printf("%d", fe);       
            }
            else if (p==2)
            {
                ++p;
                lcd.locate(2,1);
                lcd.printf("%d", kp);
                lcd.locate(2,1);               
            }
            else if (p==3)
            {
                ++p;
                lcd.locate(8,1);
                lcd.printf("%d", ki);               
            }
            else if (p==4)
            {
                ++p;
                lcd.locate(13,1);
                lcd.printf("%d", kd);              
            }
             else if (p==5)
            {
                p=1;
                lcd.locate(3,0);
                lcd.printf("%d", sp);                            
            }
          
        }
        
        if (button4.falling()){
           break;     //sale del bucle si pisan suiche4
               }
                        
      }                                  
           lcd.writeCommand(C4);//escribimos un comando segun el manual del modulo LCD para quitar cursor bajo
           lcd.cls(); //borra la pantalla
           lcd.printf("   GUARDADOS!"); 
           wait(1);
           lcd.cls();
           lcd.printf(" INICIA EL PID");
           wait(1);
           // se imprimen los parches del control  *****************************************
           lcd.cls();
           lcd.printf("Er=%d",err);
           lcd.locate(8,0);
           lcd.printf("Me=%d",med);
           lcd.locate(0,1);
           lcd.printf("Sp=%d",sp);
           lcd.locate(8,1);
           lcd.printf("SC=%d",pid);
           wait(1);
           
           // CICLO PRINCIPAL CONTROLADOR PID
            // DEFINIMOS LOS PARAMETROS Kp,Ki y Kd teniendo en cuenta la escala 
            
            kp= kp*fe;
            ki = ki*fe;
           kd= kd*fe;
           
           cicloPID :
           
           med=10*Vin.read();                  //leer puerto analogo y asignar a med
           err = (sp-med);
           ap = kp*err;
           
           ai=(ki*err)+ai;
              //calculo de la integral del error
           
           ad = kd*(err-err_v); //calculo de la accion derivativa
           pid = (ap+ai+ad);
           
           if (pid < 0){
           pid=0;
           } 
           if (pid > 99){
           pid=100;
           } 
           
           wait(.5);
           if(err >= 0){
            lcd.locate(4,0);
           lcd.printf(" ");
           lcd.locate(3,0);
           lcd.printf("%d",err);
           }
           if (err<0){
               lcd.locate(3,0);
           lcd.printf("%d",err);
               }
           lcd.locate(12,0);
           lcd.printf(" ");
           lcd.locate(11,0);
           lcd.printf("%d",med);
           lcd.locate(3,1);
           lcd.printf("%d",sp);
           
           if(pid < 100){
           lcd.locate(13,1);
           lcd.printf(" ");
           lcd.locate(11,1);
           lcd.printf("%d",pid);}
           
           if(pid >= 100){
           lcd.locate(11,1);
           lcd.printf("%d",pid);}
           
           err_v = err;  
           pidn=pid*0.01;//Normalizacion de la salida
           Vout.write(pidn);//se envia el valor pid a puerto analogico de salida (D/A)
           wait(0.005);  
        goto cicloPID ;              
  
       
}