//////////////////////
// TAREA_5_IRDA
//////////////////////
#include "mbed.h"
#include <Pulse1.h>
#include "TextLCD.h"

//control remoto videobeam aula
PulseInOut irda(PTD5);// en este puerto se pone el sensor infrarrojo
Serial pc(USBTX, USBRX);
TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7

DigitalOut led(LED1);
DigitalOut led2(LED2);

// variables
int headerL =0; //tiempo de cabecera pulso abajo
int headerH =0;
const int head_H = 4492; //+0.5% medida con osciloscopio en microsegundos
const int head_L = 4447;//-0.5%  medida con osciloscopio
int i=0;
const int T_alto=1700;//ponga su tiempo de la prueba
const int T_bajo=600;//ponga su tiempo de la prueba
const int num_bits = 32;//ponga su numero de bits
int num[num_bits];//cadena para almacenar todos los tiempos que conforman los bits de datos
int dato; // tiempo de cada dato que se lee
int bin[num_bits];
int p;
int b;
int a;
int C1=0x0F;
int C4=0x0C; // quito cursor bajo
  
int main(){
    
    lcd.cls();
    lcd.writeCommand(C1);//escribimos un comando segun el manual del modulo LCD
while(1){
ini1: fflush( stdin );
      headerL=0;
      headerH=0;
      led2=1;
      led=0;
     
    
         headerL = irda.read_low_us();    //funcion para leer un pulso de caida o bajo en header
         pc.printf("Header bajo dura %d us\n",  headerL);
         lcd.cls();
         lcd.locate(0,0);
         lcd.printf("HL=%d us", headerL); 
         wait(0.1);
          headerH= irda.read_high_us(); 
         pc.printf("Header alto dura %d us\n",  headerH); 
         lcd.locate(0,1);
         lcd.printf("HH=%d us", headerH); 
         wait(0.3);
         led=1;
      
      if (headerL > head_L && headerL < head_H) goto seguir;//verificar que este en la tolerancia +-1,8%
      else goto ini1;
      
seguir:
       //leo los datos de la trama y se meten a un arreglo
      ///wait_us(4470);// ES EL TIEMPO DE HEADER QUE NO SE Lee O EL ALTO 
      lcd.writeCommand(C4);//escribimos un comando segun el manual del modulo LCD para quitar cursor bajo
      wait_us(600);
      led2=0;
      for(i=0;i<(num_bits);++i){ // POR OSCILOSCOPIO se determina que llegan (num_bits),datos
      dato = irda.read_high_us(); //leer un bit de datos que es pulso arriba en este control
      num[i]=dato;   
       }

      
      wait(0.5);//espero un poquito luego de leer todo el arreglo y ponerlo en pantalla 
      for(i=0;i<(num_bits);++i){  
      pc.printf(",%d",num[i]);
      }
     
      wait(0.1);  //espero e imprimo en binario 
      pc.printf("\n\n");
       b=0;
      a=0;
      int c=0;
      int d=0;
      for(i=0;i<(num_bits);++i){  
        if(num[i] > ((T_alto+T_bajo)/2)) {
            b = num[i]+b;
            bin[i]=1;  
                 pc.printf("%d",bin[i]);
                 a = a+1;
             }
        if(num[i] < ((T_alto+T_bajo)/2)) {
               c = num[i]+c;
              bin[i]=0;
                pc.printf("%d",bin[i]);
                d = d+1;
          }
      }
     pc.printf("\n\n"); 
      int h1 = b/a;
      int h0 = c/d;
      pc.printf(" tide unos1 =%d",b);
      pc.printf(", can1 =%d",a);
      pc.printf(" tide unoso =%d",c);
      pc.printf(", can0 =%d",d);
    
     pc.printf("\n\n");
      wait (0.3);
    pc.printf(" t_unos =%d",h1);
      pc.printf(", t_ceros =%d",h0);
    
    

      lcd.locate(0,0);
      lcd.printf("N_bits = %d",i); 
    wait(1);
    
      lcd.locate(0,0);
      lcd.printf("t_unos = %d",h1); 
      lcd.locate(0,1);
      lcd.printf("t_ceros = %d",h0);
   wait(1);
    pc.printf("\n\n");
           lcd.cls();
           lcd.printf("N_HEX=");
   for (i=0;i< num_bits;i =i+4){
    
        long int x = bin[i]*8+bin[i+1]*4+bin[i+2]*2+bin[i+3];
       pc.printf("%x",x); 
       lcd.printf("%x",x);
     }
     
  }
}