/**
@file timeManager.h
@brief Header file
*/
Serial serial(USBTX,USBRX);
void serialISR(); // ISR that is called when serial data is received
void setTime(); // function to set the UNIX time
int setTimeFlag = 0; // flag for ISR
char rxString[16]; // buffer to store received string
void timer2Expired();
Ticker timer2;
int timer2Flag = 0;
char buffer2[30]; // buffer used to store time string
void getCurrentTime();
void chkUpdateTime();



void setTime()
{
// print time for debugging
    serial.printf("\n\n\rset_time - %s",rxString);
// atoi() converts a string to an integer
    int time = atoi(rxString);
// update the time
    set_time(time); //string of numbers from epoch like "1430659413"
}
void serialISR()
{
    
// when a serial interrupt occurs, read rx string into buffer
    serial.gets(rxString,16);
// set flag
    setTimeFlag = 1;
}    
//ISR
void timer2Expired()
{
    timer2Flag = 1;   
}  

//if (timer2Flag)
void getCurrentTime()
{
    timer2Flag = 0;
    time_t seconds = time(NULL); // get current time
    // format time into a string (time and date)
    strftime(buffer2, 30 , "%R %d %b", localtime(&seconds));
    // print over serial
    serial.printf("\n\n\rTime = %s\n",buffer2);          
}    


//if (setTimeFlag)
void chkUpdateTime() 
{ // if updated time has been sent
    setTimeFlag = 0; // clear flag
    setTime(); // update time
}

