#include "Thermistor.h"

Thermistor::Thermistor(AnalogIn inputChanel, double a, double b, double c):input(inputChanel), error(0){
    this->a = a;    
    this->b = b;
    this->c = c;
}


double Thermistor::getTemperature(){
    return getTemperatureByAdcValue(input.read(), a, b, c, error);
}

double Thermistor::getTemperatureByAdcValue(float adcVal, double a, double b, double c, double error){
    double temp;
    double realV;
    double resistance;
        //3.3 - ADC maximum
    realV = adcVal*3.3;
    resistance = (10000 * 3.3) / realV - 10000;
        //Considering the error
    resistance -= error;
        //Calculations using Steinhart–Hart equation
    temp = log(resistance);
    temp = 1/(a+b*temp+c*temp*temp*temp);
        //Convert from Fahrenheit to Celsius
    temp -= 273.15;
    return temp;
}
    
    
    void Thermistor::setError(double error){
        this->error = error;
    }
    
    double Thermistor::getError(){
        return error;
    }
    
    void Thermistor::setCoefficientA(double a){
        this->a = a;
    }
    
    void Thermistor::setCoefficientB(double b){
        this->b = b;
    }

    void Thermistor::setCoefficientC(double c){
        this->c = c;
    }
    
    double Thermistor::getCoefficientA(){
        return a;
    }
    
    double Thermistor::getCoefficientB(){
        return b;
    }
    
    double Thermistor::getCoefficientC(){
        return c;
    }
    
    bool ThermistorTest::adcValue_0_049_is_0_degree(){
        return abs(Thermistor::getTemperatureByAdcValue(0.049, 0.001995, 0.00007997, 0.0000003863)) < 1.0;
    }

    bool ThermistorTest::adcValue_0_104_is_15_degree(){
        return abs(Thermistor::getTemperatureByAdcValue(0.104, 0.001995, 0.00007997, 0.0000003863) - 15.0) < 1.0;
    }    
    
    bool ThermistorTest::adcValue_0_202_is_30_degree(){
        return abs(Thermistor::getTemperatureByAdcValue(0.202, 0.001995, 0.00007997, 0.0000003863) - 30.0) < 1.0;
    }    