#ifndef ThermometerTMP36_H
#define ThermometerTMP36_H

#include "mbed.h"
/** 
* Reads the data from the sensor TMP36, 
* connected to the analog input and converts them to Celsius
*/
class ThermometerTmp36{  
public:
    /**
    * Constructor
    *
    * @param inputChanel The analog input is connected to the sensor
    */
    ThermometerTmp36(AnalogIn inputChanel):input(inputChanel){}
    
    /**
    * The temperature in degrees Celsius
    *
    * @returns Temperature
    */
    double getTemperature();
    
    /**
    * The temperature in degrees Celsius, calculated based on a parameter.
    * Сomfortably for testing.
    *
    * @param adcVal ADC value on the port to which the sensor is connected
    *
    * @returns Temperature
    */
    static double getTemperatureByAdcValue(float adcVal);
    
private:
    AnalogIn input;
};

/**
* Tested the class ThermometerTmp36
*/
class ThermometerTmp36Test{
public:
    static bool adcValue_0_15_is_0_degree();
    static bool adcValue_0_196_is_15_degree();
    static bool adcValue_0_242_is_30_degree();
};

#endif