#include "Photoresistor.h"

Photoresistor::Photoresistor(AnalogIn inputChanel):input(inputChanel){}

Illumination Photoresistor::getIllumination(){
    return getIlluminationByAdcValue(input.read());
}

Illumination Photoresistor::getIlluminationByAdcValue(float adcVal){
    double realV;
        //3.3 - ADC maximum
    realV = adcVal*3.3;
    
    if(realV > 0){
        double resistance = (10.0 * 3.3) / realV - 10.0; //resistance in kOhms.
        if(resistance >= 1000.0) return DARK;
        if(resistance >= 19.0) return VERY_CLOUDLY; //approximately <10 lx
        if(resistance >= 0.7) return CLOUDLY; //approximately <5000 lx
        if(resistance >= 0.25) return CLEAR; //approximately <10000 lx
        return VERY_SUNNY; //approximately >10000 lx
    }else{
            return DARK; //resistance == +inf. No light 
        }
}

bool PhotoresistorTest::adcValue_0_isDark(){
    return Photoresistor::getIlluminationByAdcValue(0.0)==DARK;
}

bool PhotoresistorTest::adcValue_0_009_isDark(){
    return Photoresistor::getIlluminationByAdcValue(0.009)==DARK;
}

bool PhotoresistorTest::adcValue_0_34_isVeryCloudly(){
    return Photoresistor::getIlluminationByAdcValue(0.34)==VERY_CLOUDLY;
}

bool PhotoresistorTest::adcValue_0_93_isCloudly(){    
    return Photoresistor::getIlluminationByAdcValue(0.93)==CLOUDLY;
}

bool PhotoresistorTest::adcValue_0_97_isClear(){
    return Photoresistor::getIlluminationByAdcValue(0.97)==CLEAR;
}

bool PhotoresistorTest::adcValue_0_98_isVerySunny(){
    return Photoresistor::getIlluminationByAdcValue(0.98)==VERY_SUNNY;
}    