#include "ThermometerTmp36.h"

double ThermometerTmp36::getTemperature(){
    return getTemperatureByAdcValue(input.read());
}

double ThermometerTmp36::getTemperatureByAdcValue(float adcVal){
    double temp;
    double realV;
        //3.3 - ADC maximum
    realV = adcVal*3.3;
        //500mV - voltage in 0 degree
        //For mo information look datasheet 
        //Low Voltage Temperature Sensors TMP35/TMP36/TMP37
        //Page 5 of 20, Figure 6 (Output Voltage vs. Temperature)
    temp = (realV - 0.5)*100;
    return temp;
}

bool ThermometerTmp36Test::adcValue_0_15_is_0_degree(){
    return abs(ThermometerTmp36::getTemperatureByAdcValue(0.15)) < 0.5;
}

bool ThermometerTmp36Test::adcValue_0_196_is_15_degree(){
    return abs(ThermometerTmp36::getTemperatureByAdcValue(0.196) - 15.0) < 0.5;
}

bool ThermometerTmp36Test::adcValue_0_242_is_30_degree(){
    return abs(ThermometerTmp36::getTemperatureByAdcValue(0.242) - 30.0) < 0.5;
}