#include "WirelessListener.h"

WirelessListener::WirelessListener(uint64_t readPipe, uint64_t writePipe){
    this->readPipe = readPipe;
    this->writePipe = writePipe;
    
    radio = new RF24(P1_22, P1_21, P1_20, P1_25, P1_24);
    wirelessInit();
    
    termTmp36 = new ThermometerTmp36(AnalogIn(A0));
    term503 = new Thermistor(AnalogIn(A1), 0.001995, 0.00007997, 0.0000003863);
    //term503->setError(-5000);
    photores = new Photoresistor(AnalogIn(A2));
    
    
}

WirelessListener::~WirelessListener(){
    delete(radio);
    delete(termTmp36);
    delete(term503);
    delete(photores);
}

void WirelessListener::wirelessInit(){
    radio->begin();
    radio->setAutoAck(true);
    radio->enableAckPayload();
    radio->powerUp();
    radio->setPALevel(RF24_PA_HIGH);
    radio->setDataRate(RF24_2MBPS);
    radio->setRetries(15,15); // Retry 15 times with 4000us delay between retries.
    radio->openReadingPipe(1,readPipe);
    radio->openWritingPipe(writePipe);   
}

void WirelessListener::startListening(){
    radio->startListening();
    //--------------------------------
    //платформозависимая от базы часть
        short request;
        short response;
    //--------------------------------
    while(1){
        if(radio->available()){
        #ifdef DEBUG
            pc.printf("available()\r\n");
        #endif
        radio->read(&request, sizeof(request));
        #ifdef DEBUG
            pc.printf("request = %d\r\n", request);
        #endif
        switch(request){
        case SHADE_TEMPERATURE:
            response = termTmp36->getTemperature()*100.0;
            break;
        case LIGHT_TEMPERATURE:
            response = term503->getTemperature()*100.0;
            break;   
        case LIGHT:
            response = photores->getIllumination();
            break;
        default:
            response = 0;
        }
        #ifdef DEBUG
        pc.printf("response = %d\r\n", response);
        #endif
        radio->stopListening();
        radio->write(&response, sizeof(response));
        radio->startListening();
        }
    }    
}