#ifndef PHOTORESISTOR_H
#define PHOTORESISTOR_H

#include "mbed.h"
#include "Illumination.h"
/**
* Reads the resistance of photoresistor and associates it with 
* the light level of illumination provided by enum Illumination.
*/
class Photoresistor{  
public:
    /**
    * Constructor
    *
    * @param inputChanel The analog input is connected to the photoresistor
    */
    Photoresistor(AnalogIn inputChanel);
    
    /**
    * Level of illumination provided by enum Illumination
    *
    * @returns Level of illumination
    */
    Illumination getIllumination();

    /**
    * Level of illumination provided by enum Illumination.
    * Сomfortably for testing.
    *
    * @param adcVal ADC value on the port to which the sensor is connected
    *
    * @returns Level of illumination
    */
    static Illumination getIlluminationByAdcValue(float adcVal);
    
private:
    AnalogIn input;
};

/**
* Tested the class Photoresistor
*/
class PhotoresistorTest{
public:
    static bool adcValue_0_isDark();
    static bool adcValue_0_009_isDark();
    static bool adcValue_0_34_isVeryCloudly();
    static bool adcValue_0_93_isCloudly();
    static bool adcValue_0_97_isClear();
    static bool adcValue_0_98_isVerySunny();
};

#endif