#ifndef WIRELESSLISTENER_H
#define WIRELESSLISTENER_H

#include "mbed.h"
#include "RF24.h"
#include "RequestsCodes.h"
#include "ThermometerTmp36.h"
#include "Thermistor.h"
#include "Photoresistor.h"

//#define DEBUG

#ifdef DEBUG
#include "USBSerial.h"
#endif

/**
* Encapsulates inside accept requests, processing (reading sensor data) and transmission back
*/
class WirelessListener{  
public:
    /**
    * The request handler
    * @param readPipe Pipe identifier for receiving
    * @param writePipe Pipe identifier for transmission 
    */
    WirelessListener(uint64_t readPipe, uint64_t writePipe);
    
    ~WirelessListener();
   
    /**
    * Start receiving and processing requests
    */    
    void startListening();
    
    
private:
#ifdef DEBUG
    USBSerial pc;
#endif
    //Initialization of the transmitter
    void wirelessInit();
    
    //Receiving pipe
    uint64_t readPipe;
    //Transmission pipe
    uint64_t writePipe;
    //Transmitter
    RF24 *radio;
    
    //Sensors
    ThermometerTmp36 *termTmp36;
    Thermistor *term503;
    Photoresistor *photores;
    
};

#endif